/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountListCopier;
import software.amazon.awssdk.services.grafana.model.ServiceAccountSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspaceServiceAccountsResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, ListWorkspaceServiceAccountsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkspaceServiceAccountsResponse.getter(ListWorkspaceServiceAccountsResponse::nextToken)).setter(ListWorkspaceServiceAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServiceAccountSummary>> SERVICE_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceAccounts").getter(ListWorkspaceServiceAccountsResponse.getter(ListWorkspaceServiceAccountsResponse::serviceAccounts)).setter(ListWorkspaceServiceAccountsResponse.setter(Builder::serviceAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceAccountSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(ListWorkspaceServiceAccountsResponse.getter(ListWorkspaceServiceAccountsResponse::workspaceId)).setter(ListWorkspaceServiceAccountsResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_ACCOUNTS_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("serviceAccounts", SERVICE_ACCOUNTS_FIELD);
            this.put("workspaceId", WORKSPACE_ID_FIELD);
        }
    });
    private final String nextToken;
    private final List<ServiceAccountSummary> serviceAccounts;
    private final String workspaceId;

    private ListWorkspaceServiceAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceAccounts = builder.serviceAccounts;
        this.workspaceId = builder.workspaceId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServiceAccounts() {
        return this.serviceAccounts != null && !(this.serviceAccounts instanceof SdkAutoConstructList);
    }

    public final List<ServiceAccountSummary> serviceAccounts() {
        return this.serviceAccounts;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceAccounts() ? this.serviceAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceServiceAccountsResponse)) {
            return false;
        }
        ListWorkspaceServiceAccountsResponse other = (ListWorkspaceServiceAccountsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServiceAccounts() == other.hasServiceAccounts() && Objects.equals(this.serviceAccounts(), other.serviceAccounts()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspaceServiceAccountsResponse").add("NextToken", (Object)this.nextToken()).add("ServiceAccounts", this.hasServiceAccounts() ? this.serviceAccounts() : null).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "serviceAccounts": {
                return Optional.ofNullable(clazz.cast(this.serviceAccounts()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceServiceAccountsResponse, T> g) {
        return obj -> g.apply((ListWorkspaceServiceAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceAccountSummary> serviceAccounts = DefaultSdkAutoConstructList.getInstance();
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceServiceAccountsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serviceAccounts(model.serviceAccounts);
            this.workspaceId(model.workspaceId);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceAccountSummary.Builder> getServiceAccounts() {
            List<ServiceAccountSummary.Builder> result = ServiceAccountListCopier.copyToBuilder(this.serviceAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceAccounts(Collection<ServiceAccountSummary.BuilderImpl> serviceAccounts) {
            this.serviceAccounts = ServiceAccountListCopier.copyFromBuilder(serviceAccounts);
        }

        @Override
        public final Builder serviceAccounts(Collection<ServiceAccountSummary> serviceAccounts) {
            this.serviceAccounts = ServiceAccountListCopier.copy(serviceAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccounts(ServiceAccountSummary ... serviceAccounts) {
            this.serviceAccounts(Arrays.asList(serviceAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccounts(Consumer<ServiceAccountSummary.Builder> ... serviceAccounts) {
            this.serviceAccounts(Stream.of(serviceAccounts).map(c -> (ServiceAccountSummary)((ServiceAccountSummary.Builder)ServiceAccountSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public ListWorkspaceServiceAccountsResponse build() {
            return new ListWorkspaceServiceAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspaceServiceAccountsResponse> {
        public Builder nextToken(String var1);

        public Builder serviceAccounts(Collection<ServiceAccountSummary> var1);

        public Builder serviceAccounts(ServiceAccountSummary ... var1);

        public Builder serviceAccounts(Consumer<ServiceAccountSummary.Builder> ... var1);

        public Builder workspaceId(String var1);
    }
}

