/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.grafana.model.AccountAccessType;
import software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes;
import software.amazon.awssdk.services.grafana.model.AuthenticationProvidersCopier;
import software.amazon.awssdk.services.grafana.model.DataSourceType;
import software.amazon.awssdk.services.grafana.model.DataSourceTypesListCopier;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationType;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationsListCopier;
import software.amazon.awssdk.services.grafana.model.OrganizationalUnitListCopier;
import software.amazon.awssdk.services.grafana.model.PermissionType;
import software.amazon.awssdk.services.grafana.model.TagMapCopier;
import software.amazon.awssdk.services.grafana.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, CreateWorkspaceRequest> {
    private static final SdkField<String> ACCOUNT_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountAccessType").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::accountAccessTypeAsString)).setter(CreateWorkspaceRequest.setter(Builder::accountAccessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAccessType").build()}).build();
    private static final SdkField<List<String>> AUTHENTICATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authenticationProviders").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::authenticationProvidersAsStrings)).setter(CreateWorkspaceRequest.setter(Builder::authenticationProvidersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::clientToken)).setter(CreateWorkspaceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuration").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::configuration)).setter(CreateWorkspaceRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> GRAFANA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaVersion").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::grafanaVersion)).setter(CreateWorkspaceRequest.setter(Builder::grafanaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersion").build()}).build();
    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkAccessControl").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::networkAccessControl)).setter(CreateWorkspaceRequest.setter(Builder::networkAccessControl)).constructor(NetworkAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAccessControl").build()}).build();
    private static final SdkField<String> ORGANIZATION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationRoleName").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::organizationRoleName)).setter(CreateWorkspaceRequest.setter(Builder::organizationRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRoleName").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionType").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::permissionTypeAsString)).setter(CreateWorkspaceRequest.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionType").build()}).build();
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackSetName").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::stackSetName)).setter(CreateWorkspaceRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackSetName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::tags)).setter(CreateWorkspaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::vpcConfiguration)).setter(CreateWorkspaceRequest.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<List<String>> WORKSPACE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaceDataSources").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::workspaceDataSourcesAsStrings)).setter(CreateWorkspaceRequest.setter(Builder::workspaceDataSourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceDescription").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::workspaceDescription)).setter(CreateWorkspaceRequest.setter(Builder::workspaceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDescription").build()}).build();
    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceName").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::workspaceName)).setter(CreateWorkspaceRequest.setter(Builder::workspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceName").build()}).build();
    private static final SdkField<List<String>> WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaceNotificationDestinations").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::workspaceNotificationDestinationsAsStrings)).setter(CreateWorkspaceRequest.setter(Builder::workspaceNotificationDestinationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceNotificationDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WORKSPACE_ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaceOrganizationalUnits").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::workspaceOrganizationalUnits)).setter(CreateWorkspaceRequest.setter(Builder::workspaceOrganizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceOrganizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceRoleArn").getter(CreateWorkspaceRequest.getter(CreateWorkspaceRequest::workspaceRoleArn)).setter(CreateWorkspaceRequest.setter(Builder::workspaceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ACCESS_TYPE_FIELD, AUTHENTICATION_PROVIDERS_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, GRAFANA_VERSION_FIELD, NETWORK_ACCESS_CONTROL_FIELD, ORGANIZATION_ROLE_NAME_FIELD, PERMISSION_TYPE_FIELD, STACK_SET_NAME_FIELD, TAGS_FIELD, VPC_CONFIGURATION_FIELD, WORKSPACE_DATA_SOURCES_FIELD, WORKSPACE_DESCRIPTION_FIELD, WORKSPACE_NAME_FIELD, WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD, WORKSPACE_ORGANIZATIONAL_UNITS_FIELD, WORKSPACE_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountAccessType", ACCOUNT_ACCESS_TYPE_FIELD);
            this.put("authenticationProviders", AUTHENTICATION_PROVIDERS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("grafanaVersion", GRAFANA_VERSION_FIELD);
            this.put("networkAccessControl", NETWORK_ACCESS_CONTROL_FIELD);
            this.put("organizationRoleName", ORGANIZATION_ROLE_NAME_FIELD);
            this.put("permissionType", PERMISSION_TYPE_FIELD);
            this.put("stackSetName", STACK_SET_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
            this.put("workspaceDataSources", WORKSPACE_DATA_SOURCES_FIELD);
            this.put("workspaceDescription", WORKSPACE_DESCRIPTION_FIELD);
            this.put("workspaceName", WORKSPACE_NAME_FIELD);
            this.put("workspaceNotificationDestinations", WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD);
            this.put("workspaceOrganizationalUnits", WORKSPACE_ORGANIZATIONAL_UNITS_FIELD);
            this.put("workspaceRoleArn", WORKSPACE_ROLE_ARN_FIELD);
        }
    });
    private final String accountAccessType;
    private final List<String> authenticationProviders;
    private final String clientToken;
    private final String configuration;
    private final String grafanaVersion;
    private final NetworkAccessConfiguration networkAccessControl;
    private final String organizationRoleName;
    private final String permissionType;
    private final String stackSetName;
    private final Map<String, String> tags;
    private final VpcConfiguration vpcConfiguration;
    private final List<String> workspaceDataSources;
    private final String workspaceDescription;
    private final String workspaceName;
    private final List<String> workspaceNotificationDestinations;
    private final List<String> workspaceOrganizationalUnits;
    private final String workspaceRoleArn;

    private CreateWorkspaceRequest(BuilderImpl builder) {
        super(builder);
        this.accountAccessType = builder.accountAccessType;
        this.authenticationProviders = builder.authenticationProviders;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.grafanaVersion = builder.grafanaVersion;
        this.networkAccessControl = builder.networkAccessControl;
        this.organizationRoleName = builder.organizationRoleName;
        this.permissionType = builder.permissionType;
        this.stackSetName = builder.stackSetName;
        this.tags = builder.tags;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.workspaceDataSources = builder.workspaceDataSources;
        this.workspaceDescription = builder.workspaceDescription;
        this.workspaceName = builder.workspaceName;
        this.workspaceNotificationDestinations = builder.workspaceNotificationDestinations;
        this.workspaceOrganizationalUnits = builder.workspaceOrganizationalUnits;
        this.workspaceRoleArn = builder.workspaceRoleArn;
    }

    public final AccountAccessType accountAccessType() {
        return AccountAccessType.fromValue(this.accountAccessType);
    }

    public final String accountAccessTypeAsString() {
        return this.accountAccessType;
    }

    public final List<AuthenticationProviderTypes> authenticationProviders() {
        return AuthenticationProvidersCopier.copyStringToEnum(this.authenticationProviders);
    }

    public final boolean hasAuthenticationProviders() {
        return this.authenticationProviders != null && !(this.authenticationProviders instanceof SdkAutoConstructList);
    }

    public final List<String> authenticationProvidersAsStrings() {
        return this.authenticationProviders;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final String grafanaVersion() {
        return this.grafanaVersion;
    }

    public final NetworkAccessConfiguration networkAccessControl() {
        return this.networkAccessControl;
    }

    public final String organizationRoleName() {
        return this.organizationRoleName;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final List<DataSourceType> workspaceDataSources() {
        return DataSourceTypesListCopier.copyStringToEnum(this.workspaceDataSources);
    }

    public final boolean hasWorkspaceDataSources() {
        return this.workspaceDataSources != null && !(this.workspaceDataSources instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceDataSourcesAsStrings() {
        return this.workspaceDataSources;
    }

    public final String workspaceDescription() {
        return this.workspaceDescription;
    }

    public final String workspaceName() {
        return this.workspaceName;
    }

    public final List<NotificationDestinationType> workspaceNotificationDestinations() {
        return NotificationDestinationsListCopier.copyStringToEnum(this.workspaceNotificationDestinations);
    }

    public final boolean hasWorkspaceNotificationDestinations() {
        return this.workspaceNotificationDestinations != null && !(this.workspaceNotificationDestinations instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceNotificationDestinationsAsStrings() {
        return this.workspaceNotificationDestinations;
    }

    public final boolean hasWorkspaceOrganizationalUnits() {
        return this.workspaceOrganizationalUnits != null && !(this.workspaceOrganizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceOrganizationalUnits() {
        return this.workspaceOrganizationalUnits;
    }

    public final String workspaceRoleArn() {
        return this.workspaceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationProviders() ? this.authenticationProvidersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAccessControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceDataSources() ? this.workspaceDataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceNotificationDestinations() ? this.workspaceNotificationDestinationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceOrganizationalUnits() ? this.workspaceOrganizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceRequest)) {
            return false;
        }
        CreateWorkspaceRequest other = (CreateWorkspaceRequest)((Object)obj);
        return Objects.equals(this.accountAccessTypeAsString(), other.accountAccessTypeAsString()) && this.hasAuthenticationProviders() == other.hasAuthenticationProviders() && Objects.equals(this.authenticationProvidersAsStrings(), other.authenticationProvidersAsStrings()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.grafanaVersion(), other.grafanaVersion()) && Objects.equals(this.networkAccessControl(), other.networkAccessControl()) && Objects.equals(this.organizationRoleName(), other.organizationRoleName()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && Objects.equals(this.stackSetName(), other.stackSetName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && this.hasWorkspaceDataSources() == other.hasWorkspaceDataSources() && Objects.equals(this.workspaceDataSourcesAsStrings(), other.workspaceDataSourcesAsStrings()) && Objects.equals(this.workspaceDescription(), other.workspaceDescription()) && Objects.equals(this.workspaceName(), other.workspaceName()) && this.hasWorkspaceNotificationDestinations() == other.hasWorkspaceNotificationDestinations() && Objects.equals(this.workspaceNotificationDestinationsAsStrings(), other.workspaceNotificationDestinationsAsStrings()) && this.hasWorkspaceOrganizationalUnits() == other.hasWorkspaceOrganizationalUnits() && Objects.equals(this.workspaceOrganizationalUnits(), other.workspaceOrganizationalUnits()) && Objects.equals(this.workspaceRoleArn(), other.workspaceRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceRequest").add("AccountAccessType", (Object)this.accountAccessTypeAsString()).add("AuthenticationProviders", this.hasAuthenticationProviders() ? this.authenticationProvidersAsStrings() : null).add("ClientToken", (Object)this.clientToken()).add("Configuration", (Object)this.configuration()).add("GrafanaVersion", (Object)this.grafanaVersion()).add("NetworkAccessControl", (Object)this.networkAccessControl()).add("OrganizationRoleName", (Object)(this.organizationRoleName() == null ? null : "*** Sensitive Data Redacted ***")).add("PermissionType", (Object)this.permissionTypeAsString()).add("StackSetName", (Object)this.stackSetName()).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("WorkspaceDataSources", this.hasWorkspaceDataSources() ? this.workspaceDataSourcesAsStrings() : null).add("WorkspaceDescription", (Object)(this.workspaceDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkspaceName", (Object)(this.workspaceName() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkspaceNotificationDestinations", this.hasWorkspaceNotificationDestinations() ? this.workspaceNotificationDestinationsAsStrings() : null).add("WorkspaceOrganizationalUnits", (Object)(this.workspaceOrganizationalUnits() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkspaceRoleArn", (Object)(this.workspaceRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountAccessType": {
                return Optional.ofNullable(clazz.cast(this.accountAccessTypeAsString()));
            }
            case "authenticationProviders": {
                return Optional.ofNullable(clazz.cast(this.authenticationProvidersAsStrings()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "grafanaVersion": {
                return Optional.ofNullable(clazz.cast(this.grafanaVersion()));
            }
            case "networkAccessControl": {
                return Optional.ofNullable(clazz.cast(this.networkAccessControl()));
            }
            case "organizationRoleName": {
                return Optional.ofNullable(clazz.cast(this.organizationRoleName()));
            }
            case "permissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "stackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "workspaceDataSources": {
                return Optional.ofNullable(clazz.cast(this.workspaceDataSourcesAsStrings()));
            }
            case "workspaceDescription": {
                return Optional.ofNullable(clazz.cast(this.workspaceDescription()));
            }
            case "workspaceName": {
                return Optional.ofNullable(clazz.cast(this.workspaceName()));
            }
            case "workspaceNotificationDestinations": {
                return Optional.ofNullable(clazz.cast(this.workspaceNotificationDestinationsAsStrings()));
            }
            case "workspaceOrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.workspaceOrganizationalUnits()));
            }
            case "workspaceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.workspaceRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private String accountAccessType;
        private List<String> authenticationProviders = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String configuration;
        private String grafanaVersion;
        private NetworkAccessConfiguration networkAccessControl;
        private String organizationRoleName;
        private String permissionType;
        private String stackSetName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VpcConfiguration vpcConfiguration;
        private List<String> workspaceDataSources = DefaultSdkAutoConstructList.getInstance();
        private String workspaceDescription;
        private String workspaceName;
        private List<String> workspaceNotificationDestinations = DefaultSdkAutoConstructList.getInstance();
        private List<String> workspaceOrganizationalUnits = DefaultSdkAutoConstructList.getInstance();
        private String workspaceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceRequest model) {
            super(model);
            this.accountAccessType(model.accountAccessType);
            this.authenticationProvidersWithStrings(model.authenticationProviders);
            this.clientToken(model.clientToken);
            this.configuration(model.configuration);
            this.grafanaVersion(model.grafanaVersion);
            this.networkAccessControl(model.networkAccessControl);
            this.organizationRoleName(model.organizationRoleName);
            this.permissionType(model.permissionType);
            this.stackSetName(model.stackSetName);
            this.tags(model.tags);
            this.vpcConfiguration(model.vpcConfiguration);
            this.workspaceDataSourcesWithStrings(model.workspaceDataSources);
            this.workspaceDescription(model.workspaceDescription);
            this.workspaceName(model.workspaceName);
            this.workspaceNotificationDestinationsWithStrings(model.workspaceNotificationDestinations);
            this.workspaceOrganizationalUnits(model.workspaceOrganizationalUnits);
            this.workspaceRoleArn(model.workspaceRoleArn);
        }

        public final String getAccountAccessType() {
            return this.accountAccessType;
        }

        public final void setAccountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
        }

        @Override
        public final Builder accountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
            return this;
        }

        @Override
        public final Builder accountAccessType(AccountAccessType accountAccessType) {
            this.accountAccessType(accountAccessType == null ? null : accountAccessType.toString());
            return this;
        }

        public final Collection<String> getAuthenticationProviders() {
            if (this.authenticationProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authenticationProviders;
        }

        public final void setAuthenticationProviders(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
        }

        @Override
        public final Builder authenticationProvidersWithStrings(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProvidersWithStrings(String ... authenticationProviders) {
            this.authenticationProvidersWithStrings(Arrays.asList(authenticationProviders));
            return this;
        }

        @Override
        public final Builder authenticationProviders(Collection<AuthenticationProviderTypes> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copyEnumToString(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProviders(AuthenticationProviderTypes ... authenticationProviders) {
            this.authenticationProviders(Arrays.asList(authenticationProviders));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getGrafanaVersion() {
            return this.grafanaVersion;
        }

        public final void setGrafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
        }

        @Override
        public final Builder grafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
            return this;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessControl() {
            return this.networkAccessControl != null ? this.networkAccessControl.toBuilder() : null;
        }

        public final void setNetworkAccessControl(NetworkAccessConfiguration.BuilderImpl networkAccessControl) {
            this.networkAccessControl = networkAccessControl != null ? networkAccessControl.build() : null;
        }

        @Override
        public final Builder networkAccessControl(NetworkAccessConfiguration networkAccessControl) {
            this.networkAccessControl = networkAccessControl;
            return this;
        }

        public final String getOrganizationRoleName() {
            return this.organizationRoleName;
        }

        public final void setOrganizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
        }

        @Override
        public final Builder organizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Collection<String> getWorkspaceDataSources() {
            if (this.workspaceDataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceDataSources;
        }

        public final void setWorkspaceDataSources(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
        }

        @Override
        public final Builder workspaceDataSourcesWithStrings(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSourcesWithStrings(String ... workspaceDataSources) {
            this.workspaceDataSourcesWithStrings(Arrays.asList(workspaceDataSources));
            return this;
        }

        @Override
        public final Builder workspaceDataSources(Collection<DataSourceType> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copyEnumToString(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSources(DataSourceType ... workspaceDataSources) {
            this.workspaceDataSources(Arrays.asList(workspaceDataSources));
            return this;
        }

        public final String getWorkspaceDescription() {
            return this.workspaceDescription;
        }

        public final void setWorkspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
        }

        @Override
        public final Builder workspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
            return this;
        }

        public final String getWorkspaceName() {
            return this.workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public final Collection<String> getWorkspaceNotificationDestinations() {
            if (this.workspaceNotificationDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceNotificationDestinations;
        }

        public final void setWorkspaceNotificationDestinations(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
        }

        @Override
        public final Builder workspaceNotificationDestinationsWithStrings(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinationsWithStrings(String ... workspaceNotificationDestinations) {
            this.workspaceNotificationDestinationsWithStrings(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        @Override
        public final Builder workspaceNotificationDestinations(Collection<NotificationDestinationType> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copyEnumToString(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinations(NotificationDestinationType ... workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        public final Collection<String> getWorkspaceOrganizationalUnits() {
            if (this.workspaceOrganizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceOrganizationalUnits;
        }

        public final void setWorkspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
        }

        @Override
        public final Builder workspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceOrganizationalUnits(String ... workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits(Arrays.asList(workspaceOrganizationalUnits));
            return this;
        }

        public final String getWorkspaceRoleArn() {
            return this.workspaceRoleArn;
        }

        public final void setWorkspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
        }

        @Override
        public final Builder workspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceRequest build() {
            return new CreateWorkspaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceRequest> {
        public Builder accountAccessType(String var1);

        public Builder accountAccessType(AccountAccessType var1);

        public Builder authenticationProvidersWithStrings(Collection<String> var1);

        public Builder authenticationProvidersWithStrings(String ... var1);

        public Builder authenticationProviders(Collection<AuthenticationProviderTypes> var1);

        public Builder authenticationProviders(AuthenticationProviderTypes ... var1);

        public Builder clientToken(String var1);

        public Builder configuration(String var1);

        public Builder grafanaVersion(String var1);

        public Builder networkAccessControl(NetworkAccessConfiguration var1);

        default public Builder networkAccessControl(Consumer<NetworkAccessConfiguration.Builder> networkAccessControl) {
            return this.networkAccessControl((NetworkAccessConfiguration)((NetworkAccessConfiguration.Builder)NetworkAccessConfiguration.builder().applyMutation(networkAccessControl)).build());
        }

        public Builder organizationRoleName(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder stackSetName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder workspaceDataSourcesWithStrings(Collection<String> var1);

        public Builder workspaceDataSourcesWithStrings(String ... var1);

        public Builder workspaceDataSources(Collection<DataSourceType> var1);

        public Builder workspaceDataSources(DataSourceType ... var1);

        public Builder workspaceDescription(String var1);

        public Builder workspaceName(String var1);

        public Builder workspaceNotificationDestinationsWithStrings(Collection<String> var1);

        public Builder workspaceNotificationDestinationsWithStrings(String ... var1);

        public Builder workspaceNotificationDestinations(Collection<NotificationDestinationType> var1);

        public Builder workspaceNotificationDestinations(NotificationDestinationType ... var1);

        public Builder workspaceOrganizationalUnits(Collection<String> var1);

        public Builder workspaceOrganizationalUnits(String ... var1);

        public Builder workspaceRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

