/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes;
import software.amazon.awssdk.services.grafana.model.AuthenticationProvidersCopier;
import software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationSummary> {
    private static final SdkField<List<String>> PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("providers").getter(AuthenticationSummary.getter(AuthenticationSummary::providersAsStrings)).setter(AuthenticationSummary.setter(Builder::providersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SAML_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samlConfigurationStatus").getter(AuthenticationSummary.getter(AuthenticationSummary::samlConfigurationStatusAsString)).setter(AuthenticationSummary.setter(Builder::samlConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfigurationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDERS_FIELD, SAML_CONFIGURATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("providers", PROVIDERS_FIELD);
            this.put("samlConfigurationStatus", SAML_CONFIGURATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> providers;
    private final String samlConfigurationStatus;

    private AuthenticationSummary(BuilderImpl builder) {
        this.providers = builder.providers;
        this.samlConfigurationStatus = builder.samlConfigurationStatus;
    }

    public final List<AuthenticationProviderTypes> providers() {
        return AuthenticationProvidersCopier.copyStringToEnum(this.providers);
    }

    public final boolean hasProviders() {
        return this.providers != null && !(this.providers instanceof SdkAutoConstructList);
    }

    public final List<String> providersAsStrings() {
        return this.providers;
    }

    public final SamlConfigurationStatus samlConfigurationStatus() {
        return SamlConfigurationStatus.fromValue(this.samlConfigurationStatus);
    }

    public final String samlConfigurationStatusAsString() {
        return this.samlConfigurationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviders() ? this.providersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.samlConfigurationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationSummary)) {
            return false;
        }
        AuthenticationSummary other = (AuthenticationSummary)obj;
        return this.hasProviders() == other.hasProviders() && Objects.equals(this.providersAsStrings(), other.providersAsStrings()) && Objects.equals(this.samlConfigurationStatusAsString(), other.samlConfigurationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationSummary").add("Providers", this.hasProviders() ? this.providersAsStrings() : null).add("SamlConfigurationStatus", (Object)this.samlConfigurationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providers": {
                return Optional.ofNullable(clazz.cast(this.providersAsStrings()));
            }
            case "samlConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.samlConfigurationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationSummary, T> g) {
        return obj -> g.apply((AuthenticationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> providers = DefaultSdkAutoConstructList.getInstance();
        private String samlConfigurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationSummary model) {
            this.providersWithStrings(model.providers);
            this.samlConfigurationStatus(model.samlConfigurationStatus);
        }

        public final Collection<String> getProviders() {
            if (this.providers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.providers;
        }

        public final void setProviders(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
        }

        @Override
        public final Builder providersWithStrings(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providersWithStrings(String ... providers) {
            this.providersWithStrings(Arrays.asList(providers));
            return this;
        }

        @Override
        public final Builder providers(Collection<AuthenticationProviderTypes> providers) {
            this.providers = AuthenticationProvidersCopier.copyEnumToString(providers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providers(AuthenticationProviderTypes ... providers) {
            this.providers(Arrays.asList(providers));
            return this;
        }

        public final String getSamlConfigurationStatus() {
            return this.samlConfigurationStatus;
        }

        public final void setSamlConfigurationStatus(String samlConfigurationStatus) {
            this.samlConfigurationStatus = samlConfigurationStatus;
        }

        @Override
        public final Builder samlConfigurationStatus(String samlConfigurationStatus) {
            this.samlConfigurationStatus = samlConfigurationStatus;
            return this;
        }

        @Override
        public final Builder samlConfigurationStatus(SamlConfigurationStatus samlConfigurationStatus) {
            this.samlConfigurationStatus(samlConfigurationStatus == null ? null : samlConfigurationStatus.toString());
            return this;
        }

        public AuthenticationSummary build() {
            return new AuthenticationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationSummary> {
        public Builder providersWithStrings(Collection<String> var1);

        public Builder providersWithStrings(String ... var1);

        public Builder providers(Collection<AuthenticationProviderTypes> var1);

        public Builder providers(AuthenticationProviderTypes ... var1);

        public Builder samlConfigurationStatus(String var1);

        public Builder samlConfigurationStatus(SamlConfigurationStatus var1);
    }
}

