/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWorkspaceServiceAccountResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, DeleteWorkspaceServiceAccountResponse> {
    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountId").getter(DeleteWorkspaceServiceAccountResponse.getter(DeleteWorkspaceServiceAccountResponse::serviceAccountId)).setter(DeleteWorkspaceServiceAccountResponse.setter(Builder::serviceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountId").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(DeleteWorkspaceServiceAccountResponse.getter(DeleteWorkspaceServiceAccountResponse::workspaceId)).setter(DeleteWorkspaceServiceAccountResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_ID_FIELD, WORKSPACE_ID_FIELD));
    private final String serviceAccountId;
    private final String workspaceId;

    private DeleteWorkspaceServiceAccountResponse(BuilderImpl builder) {
        super(builder);
        this.serviceAccountId = builder.serviceAccountId;
        this.workspaceId = builder.workspaceId;
    }

    public final String serviceAccountId() {
        return this.serviceAccountId;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkspaceServiceAccountResponse)) {
            return false;
        }
        DeleteWorkspaceServiceAccountResponse other = (DeleteWorkspaceServiceAccountResponse)((Object)obj);
        return Objects.equals(this.serviceAccountId(), other.serviceAccountId()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteWorkspaceServiceAccountResponse").add("ServiceAccountId", (Object)this.serviceAccountId()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceAccountId": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountId()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkspaceServiceAccountResponse, T> g) {
        return obj -> g.apply((DeleteWorkspaceServiceAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String serviceAccountId;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkspaceServiceAccountResponse model) {
            super(model);
            this.serviceAccountId(model.serviceAccountId);
            this.workspaceId(model.workspaceId);
        }

        public final String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public DeleteWorkspaceServiceAccountResponse build() {
            return new DeleteWorkspaceServiceAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWorkspaceServiceAccountResponse> {
        public Builder serviceAccountId(String var1);

        public Builder workspaceId(String var1);
    }
}

