/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceApiKeyRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, CreateWorkspaceApiKeyRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyName").getter(CreateWorkspaceApiKeyRequest.getter(CreateWorkspaceApiKeyRequest::keyName)).setter(CreateWorkspaceApiKeyRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()}).build();
    private static final SdkField<String> KEY_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyRole").getter(CreateWorkspaceApiKeyRequest.getter(CreateWorkspaceApiKeyRequest::keyRole)).setter(CreateWorkspaceApiKeyRequest.setter(Builder::keyRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyRole").build()}).build();
    private static final SdkField<Integer> SECONDS_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("secondsToLive").getter(CreateWorkspaceApiKeyRequest.getter(CreateWorkspaceApiKeyRequest::secondsToLive)).setter(CreateWorkspaceApiKeyRequest.setter(Builder::secondsToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondsToLive").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateWorkspaceApiKeyRequest.getter(CreateWorkspaceApiKeyRequest::workspaceId)).setter(CreateWorkspaceApiKeyRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, KEY_ROLE_FIELD, SECONDS_TO_LIVE_FIELD, WORKSPACE_ID_FIELD));
    private final String keyName;
    private final String keyRole;
    private final Integer secondsToLive;
    private final String workspaceId;

    private CreateWorkspaceApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.keyRole = builder.keyRole;
        this.secondsToLive = builder.secondsToLive;
        this.workspaceId = builder.workspaceId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String keyRole() {
        return this.keyRole;
    }

    public final Integer secondsToLive() {
        return this.secondsToLive;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceApiKeyRequest)) {
            return false;
        }
        CreateWorkspaceApiKeyRequest other = (CreateWorkspaceApiKeyRequest)((Object)obj);
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.keyRole(), other.keyRole()) && Objects.equals(this.secondsToLive(), other.secondsToLive()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceApiKeyRequest").add("KeyName", (Object)this.keyName()).add("KeyRole", (Object)this.keyRole()).add("SecondsToLive", (Object)this.secondsToLive()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "keyRole": {
                return Optional.ofNullable(clazz.cast(this.keyRole()));
            }
            case "secondsToLive": {
                return Optional.ofNullable(clazz.cast(this.secondsToLive()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceApiKeyRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceApiKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private String keyName;
        private String keyRole;
        private Integer secondsToLive;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceApiKeyRequest model) {
            super(model);
            this.keyName(model.keyName);
            this.keyRole(model.keyRole);
            this.secondsToLive(model.secondsToLive);
            this.workspaceId(model.workspaceId);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyRole() {
            return this.keyRole;
        }

        public final void setKeyRole(String keyRole) {
            this.keyRole = keyRole;
        }

        @Override
        public final Builder keyRole(String keyRole) {
            this.keyRole = keyRole;
            return this;
        }

        public final Integer getSecondsToLive() {
            return this.secondsToLive;
        }

        public final void setSecondsToLive(Integer secondsToLive) {
            this.secondsToLive = secondsToLive;
        }

        @Override
        public final Builder secondsToLive(Integer secondsToLive) {
            this.secondsToLive = secondsToLive;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceApiKeyRequest build() {
            return new CreateWorkspaceApiKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceApiKeyRequest> {
        public Builder keyName(String var1);

        public Builder keyRole(String var1);

        public Builder secondsToLive(Integer var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

