/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaClient;
import software.amazon.awssdk.services.grafana.model.ListPermissionsRequest;
import software.amazon.awssdk.services.grafana.model.ListPermissionsResponse;
import software.amazon.awssdk.services.grafana.model.PermissionEntry;

public class ListPermissionsIterable
implements SdkIterable<ListPermissionsResponse> {
    private final GrafanaClient client;
    private final ListPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionsIterable(GrafanaClient client, ListPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPermissionsResponseFetcher();
    }

    public Iterator<ListPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PermissionEntry> permissions() {
        Function<ListPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPermissionsResponseFetcher
    implements SyncPageFetcher<ListPermissionsResponse> {
        private ListPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPermissionsResponse nextPage(ListPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionsIterable.this.client.listPermissions(ListPermissionsIterable.this.firstRequest);
            }
            return ListPermissionsIterable.this.client.listPermissions((ListPermissionsRequest)((Object)ListPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

