/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient;
import software.amazon.awssdk.services.grafana.model.ListPermissionsRequest;
import software.amazon.awssdk.services.grafana.model.ListPermissionsResponse;
import software.amazon.awssdk.services.grafana.model.PermissionEntry;

public class ListPermissionsPublisher
implements SdkPublisher<ListPermissionsResponse> {
    private final GrafanaAsyncClient client;
    private final ListPermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionsPublisher(GrafanaAsyncClient client, ListPermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionsPublisher(GrafanaAsyncClient client, ListPermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PermissionEntry> permissions() {
        Function<ListPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPermissionsResponseFetcher
    implements AsyncPageFetcher<ListPermissionsResponse> {
        private ListPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPermissionsResponse> nextPage(ListPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionsPublisher.this.client.listPermissions(ListPermissionsPublisher.this.firstRequest);
            }
            return ListPermissionsPublisher.this.client.listPermissions((ListPermissionsRequest)((Object)ListPermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

