/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes;
import software.amazon.awssdk.services.grafana.model.AuthenticationProvidersCopier;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.services.grafana.model.SamlConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceAuthenticationRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceAuthenticationRequest> {
    private static final SdkField<List<String>> AUTHENTICATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authenticationProviders").getter(UpdateWorkspaceAuthenticationRequest.getter(UpdateWorkspaceAuthenticationRequest::authenticationProvidersAsStrings)).setter(UpdateWorkspaceAuthenticationRequest.setter(Builder::authenticationProvidersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SamlConfiguration> SAML_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlConfiguration").getter(UpdateWorkspaceAuthenticationRequest.getter(UpdateWorkspaceAuthenticationRequest::samlConfiguration)).setter(UpdateWorkspaceAuthenticationRequest.setter(Builder::samlConfiguration)).constructor(SamlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfiguration").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateWorkspaceAuthenticationRequest.getter(UpdateWorkspaceAuthenticationRequest::workspaceId)).setter(UpdateWorkspaceAuthenticationRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_PROVIDERS_FIELD, SAML_CONFIGURATION_FIELD, WORKSPACE_ID_FIELD));
    private final List<String> authenticationProviders;
    private final SamlConfiguration samlConfiguration;
    private final String workspaceId;

    private UpdateWorkspaceAuthenticationRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationProviders = builder.authenticationProviders;
        this.samlConfiguration = builder.samlConfiguration;
        this.workspaceId = builder.workspaceId;
    }

    public final List<AuthenticationProviderTypes> authenticationProviders() {
        return AuthenticationProvidersCopier.copyStringToEnum(this.authenticationProviders);
    }

    public final boolean hasAuthenticationProviders() {
        return this.authenticationProviders != null && !(this.authenticationProviders instanceof SdkAutoConstructList);
    }

    public final List<String> authenticationProvidersAsStrings() {
        return this.authenticationProviders;
    }

    public final SamlConfiguration samlConfiguration() {
        return this.samlConfiguration;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationProviders() ? this.authenticationProvidersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.samlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceAuthenticationRequest)) {
            return false;
        }
        UpdateWorkspaceAuthenticationRequest other = (UpdateWorkspaceAuthenticationRequest)((Object)obj);
        return this.hasAuthenticationProviders() == other.hasAuthenticationProviders() && Objects.equals(this.authenticationProvidersAsStrings(), other.authenticationProvidersAsStrings()) && Objects.equals(this.samlConfiguration(), other.samlConfiguration()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceAuthenticationRequest").add("AuthenticationProviders", this.hasAuthenticationProviders() ? this.authenticationProvidersAsStrings() : null).add("SamlConfiguration", (Object)this.samlConfiguration()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationProviders": {
                return Optional.ofNullable(clazz.cast(this.authenticationProvidersAsStrings()));
            }
            case "samlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.samlConfiguration()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceAuthenticationRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceAuthenticationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private List<String> authenticationProviders = DefaultSdkAutoConstructList.getInstance();
        private SamlConfiguration samlConfiguration;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceAuthenticationRequest model) {
            super(model);
            this.authenticationProvidersWithStrings(model.authenticationProviders);
            this.samlConfiguration(model.samlConfiguration);
            this.workspaceId(model.workspaceId);
        }

        public final Collection<String> getAuthenticationProviders() {
            if (this.authenticationProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authenticationProviders;
        }

        public final void setAuthenticationProviders(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
        }

        @Override
        public final Builder authenticationProvidersWithStrings(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProvidersWithStrings(String ... authenticationProviders) {
            this.authenticationProvidersWithStrings(Arrays.asList(authenticationProviders));
            return this;
        }

        @Override
        public final Builder authenticationProviders(Collection<AuthenticationProviderTypes> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copyEnumToString(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProviders(AuthenticationProviderTypes ... authenticationProviders) {
            this.authenticationProviders(Arrays.asList(authenticationProviders));
            return this;
        }

        public final SamlConfiguration.Builder getSamlConfiguration() {
            return this.samlConfiguration != null ? this.samlConfiguration.toBuilder() : null;
        }

        public final void setSamlConfiguration(SamlConfiguration.BuilderImpl samlConfiguration) {
            this.samlConfiguration = samlConfiguration != null ? samlConfiguration.build() : null;
        }

        @Override
        public final Builder samlConfiguration(SamlConfiguration samlConfiguration) {
            this.samlConfiguration = samlConfiguration;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceAuthenticationRequest build() {
            return new UpdateWorkspaceAuthenticationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceAuthenticationRequest> {
        public Builder authenticationProvidersWithStrings(Collection<String> var1);

        public Builder authenticationProvidersWithStrings(String ... var1);

        public Builder authenticationProviders(Collection<AuthenticationProviderTypes> var1);

        public Builder authenticationProviders(AuthenticationProviderTypes ... var1);

        public Builder samlConfiguration(SamlConfiguration var1);

        default public Builder samlConfiguration(Consumer<SamlConfiguration.Builder> samlConfiguration) {
            return this.samlConfiguration((SamlConfiguration)((SamlConfiguration.Builder)SamlConfiguration.builder().applyMutation(samlConfiguration)).build());
        }

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

