/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.Sort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SortCriterion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SortCriterion> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SortCriterion.getter(SortCriterion::fieldName)).setter(SortCriterion.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SortCriterion.getter(SortCriterion::sortAsString)).setter(SortCriterion.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, SORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String sort;

    private SortCriterion(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.sort = builder.sort;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Sort sort() {
        return Sort.fromValue(this.sort);
    }

    public String sortAsString() {
        return this.sort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortCriterion)) {
            return false;
        }
        SortCriterion other = (SortCriterion)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.sortAsString(), other.sortAsString());
    }

    public String toString() {
        return ToString.builder((String)"SortCriterion").add("FieldName", (Object)this.fieldName()).add("Sort", (Object)this.sortAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sortAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SortCriterion, T> g) {
        return obj -> g.apply((SortCriterion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SortCriterion model) {
            this.fieldName(model.fieldName);
            this.sort(model.sort);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final String getSortAsString() {
            return this.sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        public SortCriterion build() {
            return new SortCriterion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SortCriterion> {
        public Builder fieldName(String var1);

        public Builder sort(String var1);

        public Builder sort(Sort var1);
    }
}

