/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserDefinedFunctionsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetUserDefinedFunctionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetUserDefinedFunctionsRequest.getter(GetUserDefinedFunctionsRequest::catalogId)).setter(GetUserDefinedFunctionsRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetUserDefinedFunctionsRequest.getter(GetUserDefinedFunctionsRequest::databaseName)).setter(GetUserDefinedFunctionsRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetUserDefinedFunctionsRequest.getter(GetUserDefinedFunctionsRequest::pattern)).setter(GetUserDefinedFunctionsRequest.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetUserDefinedFunctionsRequest.getter(GetUserDefinedFunctionsRequest::nextToken)).setter(GetUserDefinedFunctionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetUserDefinedFunctionsRequest.getter(GetUserDefinedFunctionsRequest::maxResults)).setter(GetUserDefinedFunctionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, PATTERN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final String pattern;
    private final String nextToken;
    private final Integer maxResults;

    private GetUserDefinedFunctionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.pattern = builder.pattern;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String pattern() {
        return this.pattern;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserDefinedFunctionsRequest)) {
            return false;
        }
        GetUserDefinedFunctionsRequest other = (GetUserDefinedFunctionsRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetUserDefinedFunctionsRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("Pattern", (Object)this.pattern()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserDefinedFunctionsRequest, T> g) {
        return obj -> g.apply((GetUserDefinedFunctionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String pattern;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserDefinedFunctionsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.pattern(model.pattern);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getPattern() {
            return this.pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUserDefinedFunctionsRequest build() {
            return new GetUserDefinedFunctionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserDefinedFunctionsRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder pattern(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

