/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CrawlerNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCrawlersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListCrawlersResponse> {
    private static final SdkField<List<String>> CRAWLER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCrawlersResponse.getter(ListCrawlersResponse::crawlerNames)).setter(ListCrawlersResponse.setter(Builder::crawlerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCrawlersResponse.getter(ListCrawlersResponse::nextToken)).setter(ListCrawlersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> crawlerNames;
    private final String nextToken;

    private ListCrawlersResponse(BuilderImpl builder) {
        super(builder);
        this.crawlerNames = builder.crawlerNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> crawlerNames() {
        return this.crawlerNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrawlersResponse)) {
            return false;
        }
        ListCrawlersResponse other = (ListCrawlersResponse)((Object)obj);
        return Objects.equals(this.crawlerNames(), other.crawlerNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCrawlersResponse").add("CrawlerNames", this.crawlerNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlerNames": {
                return Optional.ofNullable(clazz.cast(this.crawlerNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCrawlersResponse, T> g) {
        return obj -> g.apply((ListCrawlersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<String> crawlerNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrawlersResponse model) {
            super(model);
            this.crawlerNames(model.crawlerNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getCrawlerNames() {
            return this.crawlerNames;
        }

        @Override
        public final Builder crawlerNames(Collection<String> crawlerNames) {
            this.crawlerNames = CrawlerNameListCopier.copy(crawlerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerNames(String ... crawlerNames) {
            this.crawlerNames(Arrays.asList(crawlerNames));
            return this;
        }

        public final void setCrawlerNames(Collection<String> crawlerNames) {
            this.crawlerNames = CrawlerNameListCopier.copy(crawlerNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCrawlersResponse build() {
            return new ListCrawlersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCrawlersResponse> {
        public Builder crawlerNames(Collection<String> var1);

        public Builder crawlerNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

