/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableError> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableError.getter(TableError::tableName)).setter(TableError.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableError.getter(TableError::errorDetail)).setter(TableError.setter(Builder::errorDetail)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, ERROR_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final ErrorDetail errorDetail;

    private TableError(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.errorDetail = builder.errorDetail;
    }

    public String tableName() {
        return this.tableName;
    }

    public ErrorDetail errorDetail() {
        return this.errorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableError)) {
            return false;
        }
        TableError other = (TableError)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.errorDetail(), other.errorDetail());
    }

    public String toString() {
        return ToString.builder((String)"TableError").add("TableName", (Object)this.tableName()).add("ErrorDetail", (Object)this.errorDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableError, T> g) {
        return obj -> g.apply((TableError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(TableError model) {
            this.tableName(model.tableName);
            this.errorDetail(model.errorDetail);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return this.errorDetail != null ? this.errorDetail.toBuilder() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        public TableError build() {
            return new TableError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableError> {
        public Builder tableName(String var1);

        public Builder errorDetail(ErrorDetail var1);

        default public Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return this.errorDetail((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(errorDetail)).build());
        }
    }
}

