/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CloudWatchEncryption;
import software.amazon.awssdk.services.glue.model.JobBookmarksEncryption;
import software.amazon.awssdk.services.glue.model.S3Encryption;
import software.amazon.awssdk.services.glue.model.S3EncryptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private static final SdkField<List<S3Encryption>> S3_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncryptionConfiguration.getter(EncryptionConfiguration::s3Encryption)).setter(EncryptionConfiguration.setter(Builder::s3Encryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Encryption").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CloudWatchEncryption> CLOUD_WATCH_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncryptionConfiguration.getter(EncryptionConfiguration::cloudWatchEncryption)).setter(EncryptionConfiguration.setter(Builder::cloudWatchEncryption)).constructor(CloudWatchEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEncryption").build()}).build();
    private static final SdkField<JobBookmarksEncryption> JOB_BOOKMARKS_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncryptionConfiguration.getter(EncryptionConfiguration::jobBookmarksEncryption)).setter(EncryptionConfiguration.setter(Builder::jobBookmarksEncryption)).constructor(JobBookmarksEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarksEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ENCRYPTION_FIELD, CLOUD_WATCH_ENCRYPTION_FIELD, JOB_BOOKMARKS_ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<S3Encryption> s3Encryption;
    private final CloudWatchEncryption cloudWatchEncryption;
    private final JobBookmarksEncryption jobBookmarksEncryption;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.s3Encryption = builder.s3Encryption;
        this.cloudWatchEncryption = builder.cloudWatchEncryption;
        this.jobBookmarksEncryption = builder.jobBookmarksEncryption;
    }

    public List<S3Encryption> s3Encryption() {
        return this.s3Encryption;
    }

    public CloudWatchEncryption cloudWatchEncryption() {
        return this.cloudWatchEncryption;
    }

    public JobBookmarksEncryption jobBookmarksEncryption() {
        return this.jobBookmarksEncryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmarksEncryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        return Objects.equals(this.s3Encryption(), other.s3Encryption()) && Objects.equals(this.cloudWatchEncryption(), other.cloudWatchEncryption()) && Objects.equals(this.jobBookmarksEncryption(), other.jobBookmarksEncryption());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionConfiguration").add("S3Encryption", this.s3Encryption()).add("CloudWatchEncryption", (Object)this.cloudWatchEncryption()).add("JobBookmarksEncryption", (Object)this.jobBookmarksEncryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Encryption": {
                return Optional.ofNullable(clazz.cast(this.s3Encryption()));
            }
            case "CloudWatchEncryption": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEncryption()));
            }
            case "JobBookmarksEncryption": {
                return Optional.ofNullable(clazz.cast(this.jobBookmarksEncryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3Encryption> s3Encryption = DefaultSdkAutoConstructList.getInstance();
        private CloudWatchEncryption cloudWatchEncryption;
        private JobBookmarksEncryption jobBookmarksEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.s3Encryption(model.s3Encryption);
            this.cloudWatchEncryption(model.cloudWatchEncryption);
            this.jobBookmarksEncryption(model.jobBookmarksEncryption);
        }

        public final Collection<S3Encryption.Builder> getS3Encryption() {
            return this.s3Encryption != null ? (Collection)this.s3Encryption.stream().map(S3Encryption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Encryption(Collection<S3Encryption> s3Encryption) {
            this.s3Encryption = S3EncryptionListCopier.copy(s3Encryption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Encryption(S3Encryption ... s3Encryption) {
            this.s3Encryption(Arrays.asList(s3Encryption));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Encryption(Consumer<S3Encryption.Builder> ... s3Encryption) {
            this.s3Encryption(Stream.of(s3Encryption).map(c -> (S3Encryption)((S3Encryption.Builder)S3Encryption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Encryption(Collection<S3Encryption.BuilderImpl> s3Encryption) {
            this.s3Encryption = S3EncryptionListCopier.copyFromBuilder(s3Encryption);
        }

        public final CloudWatchEncryption.Builder getCloudWatchEncryption() {
            return this.cloudWatchEncryption != null ? this.cloudWatchEncryption.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchEncryption(CloudWatchEncryption cloudWatchEncryption) {
            this.cloudWatchEncryption = cloudWatchEncryption;
            return this;
        }

        public final void setCloudWatchEncryption(CloudWatchEncryption.BuilderImpl cloudWatchEncryption) {
            this.cloudWatchEncryption = cloudWatchEncryption != null ? cloudWatchEncryption.build() : null;
        }

        public final JobBookmarksEncryption.Builder getJobBookmarksEncryption() {
            return this.jobBookmarksEncryption != null ? this.jobBookmarksEncryption.toBuilder() : null;
        }

        @Override
        public final Builder jobBookmarksEncryption(JobBookmarksEncryption jobBookmarksEncryption) {
            this.jobBookmarksEncryption = jobBookmarksEncryption;
            return this;
        }

        public final void setJobBookmarksEncryption(JobBookmarksEncryption.BuilderImpl jobBookmarksEncryption) {
            this.jobBookmarksEncryption = jobBookmarksEncryption != null ? jobBookmarksEncryption.build() : null;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder s3Encryption(Collection<S3Encryption> var1);

        public Builder s3Encryption(S3Encryption ... var1);

        public Builder s3Encryption(Consumer<S3Encryption.Builder> ... var1);

        public Builder cloudWatchEncryption(CloudWatchEncryption var1);

        default public Builder cloudWatchEncryption(Consumer<CloudWatchEncryption.Builder> cloudWatchEncryption) {
            return this.cloudWatchEncryption((CloudWatchEncryption)((CloudWatchEncryption.Builder)CloudWatchEncryption.builder().applyMutation(cloudWatchEncryption)).build());
        }

        public Builder jobBookmarksEncryption(JobBookmarksEncryption var1);

        default public Builder jobBookmarksEncryption(Consumer<JobBookmarksEncryption.Builder> jobBookmarksEncryption) {
            return this.jobBookmarksEncryption((JobBookmarksEncryption)((JobBookmarksEncryption.Builder)JobBookmarksEncryption.builder().applyMutation(jobBookmarksEncryption)).build());
        }
    }
}

