/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Action;
import software.amazon.awssdk.services.glue.model.ActionListCopier;
import software.amazon.awssdk.services.glue.model.Predicate;
import software.amazon.awssdk.services.glue.model.TriggerState;
import software.amazon.awssdk.services.glue.model.TriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trigger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trigger> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::name)).setter(Trigger.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::workflowName)).setter(Trigger.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::id)).setter(Trigger.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::typeAsString)).setter(Trigger.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::stateAsString)).setter(Trigger.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::description)).setter(Trigger.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trigger.getter(Trigger::schedule)).setter(Trigger.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Trigger.getter(Trigger::actions)).setter(Trigger.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Trigger.getter(Trigger::predicate)).setter(Trigger.setter(Builder::predicate)).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WORKFLOW_NAME_FIELD, ID_FIELD, TYPE_FIELD, STATE_FIELD, DESCRIPTION_FIELD, SCHEDULE_FIELD, ACTIONS_FIELD, PREDICATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String workflowName;
    private final String id;
    private final String type;
    private final String state;
    private final String description;
    private final String schedule;
    private final List<Action> actions;
    private final Predicate predicate;

    private Trigger(BuilderImpl builder) {
        this.name = builder.name;
        this.workflowName = builder.workflowName;
        this.id = builder.id;
        this.type = builder.type;
        this.state = builder.state;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.actions = builder.actions;
        this.predicate = builder.predicate;
    }

    public String name() {
        return this.name;
    }

    public String workflowName() {
        return this.workflowName;
    }

    public String id() {
        return this.id;
    }

    public TriggerType type() {
        return TriggerType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public TriggerState state() {
        return TriggerState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String description() {
        return this.description;
    }

    public String schedule() {
        return this.schedule;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.workflowName(), other.workflowName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.predicate(), other.predicate());
    }

    public String toString() {
        return ToString.builder((String)"Trigger").add("Name", (Object)this.name()).add("WorkflowName", (Object)this.workflowName()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("Schedule", (Object)this.schedule()).add("Actions", this.actions()).add("Predicate", (Object)this.predicate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WorkflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Predicate": {
                return Optional.ofNullable(clazz.cast(this.predicate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trigger, T> g) {
        return obj -> g.apply((Trigger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String workflowName;
        private String id;
        private String type;
        private String state;
        private String description;
        private String schedule;
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private Predicate predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(Trigger model) {
            this.name(model.name);
            this.workflowName(model.workflowName);
            this.id(model.id);
            this.type(model.type);
            this.state(model.state);
            this.description(model.description);
            this.schedule(model.schedule);
            this.actions(model.actions);
            this.predicate(model.predicate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TriggerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TriggerState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        public Trigger build() {
            return new Trigger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trigger> {
        public Builder name(String var1);

        public Builder workflowName(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(TriggerType var1);

        public Builder state(String var1);

        public Builder state(TriggerState var1);

        public Builder description(String var1);

        public Builder schedule(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().applyMutation(predicate)).build());
        }
    }
}

