/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.JobBookmarksEncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobBookmarksEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobBookmarksEncryption> {
    private static final SdkField<String> JOB_BOOKMARKS_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobBookmarksEncryption.getter(JobBookmarksEncryption::jobBookmarksEncryptionModeAsString)).setter(JobBookmarksEncryption.setter(Builder::jobBookmarksEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarksEncryptionMode").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobBookmarksEncryption.getter(JobBookmarksEncryption::kmsKeyArn)).setter(JobBookmarksEncryption.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_BOOKMARKS_ENCRYPTION_MODE_FIELD, KMS_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobBookmarksEncryptionMode;
    private final String kmsKeyArn;

    private JobBookmarksEncryption(BuilderImpl builder) {
        this.jobBookmarksEncryptionMode = builder.jobBookmarksEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public JobBookmarksEncryptionMode jobBookmarksEncryptionMode() {
        return JobBookmarksEncryptionMode.fromValue(this.jobBookmarksEncryptionMode);
    }

    public String jobBookmarksEncryptionModeAsString() {
        return this.jobBookmarksEncryptionMode;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmarksEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobBookmarksEncryption)) {
            return false;
        }
        JobBookmarksEncryption other = (JobBookmarksEncryption)obj;
        return Objects.equals(this.jobBookmarksEncryptionModeAsString(), other.jobBookmarksEncryptionModeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"JobBookmarksEncryption").add("JobBookmarksEncryptionMode", (Object)this.jobBookmarksEncryptionModeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobBookmarksEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.jobBookmarksEncryptionModeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobBookmarksEncryption, T> g) {
        return obj -> g.apply((JobBookmarksEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobBookmarksEncryptionMode;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JobBookmarksEncryption model) {
            this.jobBookmarksEncryptionMode(model.jobBookmarksEncryptionMode);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getJobBookmarksEncryptionModeAsString() {
            return this.jobBookmarksEncryptionMode;
        }

        @Override
        public final Builder jobBookmarksEncryptionMode(String jobBookmarksEncryptionMode) {
            this.jobBookmarksEncryptionMode = jobBookmarksEncryptionMode;
            return this;
        }

        @Override
        public final Builder jobBookmarksEncryptionMode(JobBookmarksEncryptionMode jobBookmarksEncryptionMode) {
            this.jobBookmarksEncryptionMode(jobBookmarksEncryptionMode == null ? null : jobBookmarksEncryptionMode.toString());
            return this;
        }

        public final void setJobBookmarksEncryptionMode(String jobBookmarksEncryptionMode) {
            this.jobBookmarksEncryptionMode = jobBookmarksEncryptionMode;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public JobBookmarksEncryption build() {
            return new JobBookmarksEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobBookmarksEncryption> {
        public Builder jobBookmarksEncryptionMode(String var1);

        public Builder jobBookmarksEncryptionMode(JobBookmarksEncryptionMode var1);

        public Builder kmsKeyArn(String var1);
    }
}

