/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.JobRun;
import software.amazon.awssdk.services.glue.model.JobRunListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetJobRunsResponse> {
    private static final SdkField<List<JobRun>> JOB_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetJobRunsResponse.getter(GetJobRunsResponse::jobRuns)).setter(GetJobRunsResponse.setter(Builder::jobRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobRunsResponse.getter(GetJobRunsResponse::nextToken)).setter(GetJobRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobRun> jobRuns;
    private final String nextToken;

    private GetJobRunsResponse(BuilderImpl builder) {
        super(builder);
        this.jobRuns = builder.jobRuns;
        this.nextToken = builder.nextToken;
    }

    public List<JobRun> jobRuns() {
        return this.jobRuns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunsResponse)) {
            return false;
        }
        GetJobRunsResponse other = (GetJobRunsResponse)((Object)obj);
        return Objects.equals(this.jobRuns(), other.jobRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetJobRunsResponse").add("JobRuns", this.jobRuns()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobRuns": {
                return Optional.ofNullable(clazz.cast(this.jobRuns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobRunsResponse, T> g) {
        return obj -> g.apply((GetJobRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<JobRun> jobRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunsResponse model) {
            super(model);
            this.jobRuns(model.jobRuns);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobRun.Builder> getJobRuns() {
            return this.jobRuns != null ? (Collection)this.jobRuns.stream().map(JobRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunListCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun ... jobRuns) {
            this.jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(Consumer<JobRun.Builder> ... jobRuns) {
            this.jobRuns(Stream.of(jobRuns).map(c -> (JobRun)((JobRun.Builder)JobRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunListCopier.copyFromBuilder(jobRuns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetJobRunsResponse build() {
            return new GetJobRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobRunsResponse> {
        public Builder jobRuns(Collection<JobRun> var1);

        public Builder jobRuns(JobRun ... var1);

        public Builder jobRuns(Consumer<JobRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

