/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MappingEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MappingEntry> {
    private static final SdkField<String> SOURCE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MappingEntry.getter(MappingEntry::sourceTable)).setter(MappingEntry.setter(Builder::sourceTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTable").build()}).build();
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MappingEntry.getter(MappingEntry::sourcePath)).setter(MappingEntry.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MappingEntry.getter(MappingEntry::sourceType)).setter(MappingEntry.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> TARGET_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MappingEntry.getter(MappingEntry::targetTable)).setter(MappingEntry.setter(Builder::targetTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()}).build();
    private static final SdkField<String> TARGET_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MappingEntry.getter(MappingEntry::targetPath)).setter(MappingEntry.setter(Builder::targetPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPath").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MappingEntry.getter(MappingEntry::targetType)).setter(MappingEntry.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_FIELD, SOURCE_PATH_FIELD, SOURCE_TYPE_FIELD, TARGET_TABLE_FIELD, TARGET_PATH_FIELD, TARGET_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceTable;
    private final String sourcePath;
    private final String sourceType;
    private final String targetTable;
    private final String targetPath;
    private final String targetType;

    private MappingEntry(BuilderImpl builder) {
        this.sourceTable = builder.sourceTable;
        this.sourcePath = builder.sourcePath;
        this.sourceType = builder.sourceType;
        this.targetTable = builder.targetTable;
        this.targetPath = builder.targetPath;
        this.targetType = builder.targetType;
    }

    public String sourceTable() {
        return this.sourceTable;
    }

    public String sourcePath() {
        return this.sourcePath;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String targetTable() {
        return this.targetTable;
    }

    public String targetPath() {
        return this.targetPath;
    }

    public String targetType() {
        return this.targetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingEntry)) {
            return false;
        }
        MappingEntry other = (MappingEntry)obj;
        return Objects.equals(this.sourceTable(), other.sourceTable()) && Objects.equals(this.sourcePath(), other.sourcePath()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.targetTable(), other.targetTable()) && Objects.equals(this.targetPath(), other.targetPath()) && Objects.equals(this.targetType(), other.targetType());
    }

    public String toString() {
        return ToString.builder((String)"MappingEntry").add("SourceTable", (Object)this.sourceTable()).add("SourcePath", (Object)this.sourcePath()).add("SourceType", (Object)this.sourceType()).add("TargetTable", (Object)this.targetTable()).add("TargetPath", (Object)this.targetPath()).add("TargetType", (Object)this.targetType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceTable": {
                return Optional.ofNullable(clazz.cast(this.sourceTable()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "TargetTable": {
                return Optional.ofNullable(clazz.cast(this.targetTable()));
            }
            case "TargetPath": {
                return Optional.ofNullable(clazz.cast(this.targetPath()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MappingEntry, T> g) {
        return obj -> g.apply((MappingEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceTable;
        private String sourcePath;
        private String sourceType;
        private String targetTable;
        private String targetPath;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingEntry model) {
            this.sourceTable(model.sourceTable);
            this.sourcePath(model.sourcePath);
            this.sourceType(model.sourceType);
            this.targetTable(model.targetTable);
            this.targetPath(model.targetPath);
            this.targetType(model.targetType);
        }

        public final String getSourceTable() {
            return this.sourceTable;
        }

        @Override
        public final Builder sourceTable(String sourceTable) {
            this.sourceTable = sourceTable;
            return this;
        }

        public final void setSourceTable(String sourceTable) {
            this.sourceTable = sourceTable;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getTargetTable() {
            return this.targetTable;
        }

        @Override
        public final Builder targetTable(String targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final void setTargetTable(String targetTable) {
            this.targetTable = targetTable;
        }

        public final String getTargetPath() {
            return this.targetPath;
        }

        @Override
        public final Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        public final void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public MappingEntry build() {
            return new MappingEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MappingEntry> {
        public Builder sourceTable(String var1);

        public Builder sourcePath(String var1);

        public Builder sourceType(String var1);

        public Builder targetTable(String var1);

        public Builder targetPath(String var1);

        public Builder targetType(String var1);
    }
}

