/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;
import software.amazon.awssdk.services.glue.model.Job;

public class GetJobsPublisher
implements SdkPublisher<GetJobsResponse> {
    private final GlueAsyncClient client;
    private final GetJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetJobsPublisher(GlueAsyncClient client, GetJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetJobsPublisher(GlueAsyncClient client, GetJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Job> jobs() {
        return this.flatMapIterable(response -> response.jobs());
    }

    private class GetJobsResponseFetcher
    implements AsyncPageFetcher<GetJobsResponse> {
        private GetJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetJobsResponse> nextPage(GetJobsResponse previousPage) {
            if (previousPage == null) {
                return GetJobsPublisher.this.client.getJobs(GetJobsPublisher.this.firstRequest);
            }
            return GetJobsPublisher.this.client.getJobs((GetJobsRequest)((Object)GetJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

