/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IcebergUpdateAction {
    ADD_SCHEMA("add-schema"),
    SET_CURRENT_SCHEMA("set-current-schema"),
    ADD_SPEC("add-spec"),
    SET_DEFAULT_SPEC("set-default-spec"),
    ADD_SORT_ORDER("add-sort-order"),
    SET_DEFAULT_SORT_ORDER("set-default-sort-order"),
    SET_LOCATION("set-location"),
    SET_PROPERTIES("set-properties"),
    REMOVE_PROPERTIES("remove-properties"),
    ADD_ENCRYPTION_KEY("add-encryption-key"),
    REMOVE_ENCRYPTION_KEY("remove-encryption-key"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IcebergUpdateAction> VALUE_MAP;
    private final String value;

    private IcebergUpdateAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IcebergUpdateAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IcebergUpdateAction> knownValues() {
        EnumSet<IcebergUpdateAction> knownValues = EnumSet.allOf(IcebergUpdateAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IcebergUpdateAction.class, IcebergUpdateAction::toString);
    }
}

