/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CompressionType;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.GlueSchema;
import software.amazon.awssdk.services.glue.model.GlueSchemasCopier;
import software.amazon.awssdk.services.glue.model.QuoteChar;
import software.amazon.awssdk.services.glue.model.S3DirectSourceAdditionalOptions;
import software.amazon.awssdk.services.glue.model.Separator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3CsvSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3CsvSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(S3CsvSource.getter(S3CsvSource::name)).setter(S3CsvSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Paths").getter(S3CsvSource.getter(S3CsvSource::paths)).setter(S3CsvSource.setter(Builder::paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(S3CsvSource.getter(S3CsvSource::compressionTypeAsString)).setter(S3CsvSource.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<List<String>> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exclusions").getter(S3CsvSource.getter(S3CsvSource::exclusions)).setter(S3CsvSource.setter(Builder::exclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GROUP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupSize").getter(S3CsvSource.getter(S3CsvSource::groupSize)).setter(S3CsvSource.setter(Builder::groupSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSize").build()}).build();
    private static final SdkField<String> GROUP_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupFiles").getter(S3CsvSource.getter(S3CsvSource::groupFiles)).setter(S3CsvSource.setter(Builder::groupFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupFiles").build()}).build();
    private static final SdkField<Boolean> RECURSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Recurse").getter(S3CsvSource.getter(S3CsvSource::recurse)).setter(S3CsvSource.setter(Builder::recurse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurse").build()}).build();
    private static final SdkField<Integer> MAX_BAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBand").getter(S3CsvSource.getter(S3CsvSource::maxBand)).setter(S3CsvSource.setter(Builder::maxBand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxBand").build()}).build();
    private static final SdkField<Integer> MAX_FILES_IN_BAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFilesInBand").getter(S3CsvSource.getter(S3CsvSource::maxFilesInBand)).setter(S3CsvSource.setter(Builder::maxFilesInBand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFilesInBand").build()}).build();
    private static final SdkField<S3DirectSourceAdditionalOptions> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalOptions").getter(S3CsvSource.getter(S3CsvSource::additionalOptions)).setter(S3CsvSource.setter(Builder::additionalOptions)).constructor(S3DirectSourceAdditionalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build()}).build();
    private static final SdkField<String> SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Separator").getter(S3CsvSource.getter(S3CsvSource::separatorAsString)).setter(S3CsvSource.setter(Builder::separator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Separator").build()}).build();
    private static final SdkField<String> ESCAPER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Escaper").getter(S3CsvSource.getter(S3CsvSource::escaper)).setter(S3CsvSource.setter(Builder::escaper)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Escaper").build()}).build();
    private static final SdkField<String> QUOTE_CHAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuoteChar").getter(S3CsvSource.getter(S3CsvSource::quoteCharAsString)).setter(S3CsvSource.setter(Builder::quoteChar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteChar").build()}).build();
    private static final SdkField<Boolean> MULTILINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Multiline").getter(S3CsvSource.getter(S3CsvSource::multiline)).setter(S3CsvSource.setter(Builder::multiline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Multiline").build()}).build();
    private static final SdkField<Boolean> WITH_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithHeader").getter(S3CsvSource.getter(S3CsvSource::withHeader)).setter(S3CsvSource.setter(Builder::withHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithHeader").build()}).build();
    private static final SdkField<Boolean> WRITE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WriteHeader").getter(S3CsvSource.getter(S3CsvSource::writeHeader)).setter(S3CsvSource.setter(Builder::writeHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteHeader").build()}).build();
    private static final SdkField<Boolean> SKIP_FIRST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipFirst").getter(S3CsvSource.getter(S3CsvSource::skipFirst)).setter(S3CsvSource.setter(Builder::skipFirst)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFirst").build()}).build();
    private static final SdkField<Boolean> OPTIMIZE_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OptimizePerformance").getter(S3CsvSource.getter(S3CsvSource::optimizePerformance)).setter(S3CsvSource.setter(Builder::optimizePerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizePerformance").build()}).build();
    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputSchemas").getter(S3CsvSource.getter(S3CsvSource::outputSchemas)).setter(S3CsvSource.setter(Builder::outputSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATHS_FIELD, COMPRESSION_TYPE_FIELD, EXCLUSIONS_FIELD, GROUP_SIZE_FIELD, GROUP_FILES_FIELD, RECURSE_FIELD, MAX_BAND_FIELD, MAX_FILES_IN_BAND_FIELD, ADDITIONAL_OPTIONS_FIELD, SEPARATOR_FIELD, ESCAPER_FIELD, QUOTE_CHAR_FIELD, MULTILINE_FIELD, WITH_HEADER_FIELD, WRITE_HEADER_FIELD, SKIP_FIRST_FIELD, OPTIMIZE_PERFORMANCE_FIELD, OUTPUT_SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3CsvSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> paths;
    private final String compressionType;
    private final List<String> exclusions;
    private final String groupSize;
    private final String groupFiles;
    private final Boolean recurse;
    private final Integer maxBand;
    private final Integer maxFilesInBand;
    private final S3DirectSourceAdditionalOptions additionalOptions;
    private final String separator;
    private final String escaper;
    private final String quoteChar;
    private final Boolean multiline;
    private final Boolean withHeader;
    private final Boolean writeHeader;
    private final Boolean skipFirst;
    private final Boolean optimizePerformance;
    private final List<GlueSchema> outputSchemas;

    private S3CsvSource(BuilderImpl builder) {
        this.name = builder.name;
        this.paths = builder.paths;
        this.compressionType = builder.compressionType;
        this.exclusions = builder.exclusions;
        this.groupSize = builder.groupSize;
        this.groupFiles = builder.groupFiles;
        this.recurse = builder.recurse;
        this.maxBand = builder.maxBand;
        this.maxFilesInBand = builder.maxFilesInBand;
        this.additionalOptions = builder.additionalOptions;
        this.separator = builder.separator;
        this.escaper = builder.escaper;
        this.quoteChar = builder.quoteChar;
        this.multiline = builder.multiline;
        this.withHeader = builder.withHeader;
        this.writeHeader = builder.writeHeader;
        this.skipFirst = builder.skipFirst;
        this.optimizePerformance = builder.optimizePerformance;
        this.outputSchemas = builder.outputSchemas;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPaths() {
        return this.paths != null && !(this.paths instanceof SdkAutoConstructList);
    }

    public final List<String> paths() {
        return this.paths;
    }

    public final CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public final boolean hasExclusions() {
        return this.exclusions != null && !(this.exclusions instanceof SdkAutoConstructList);
    }

    public final List<String> exclusions() {
        return this.exclusions;
    }

    public final String groupSize() {
        return this.groupSize;
    }

    public final String groupFiles() {
        return this.groupFiles;
    }

    public final Boolean recurse() {
        return this.recurse;
    }

    public final Integer maxBand() {
        return this.maxBand;
    }

    public final Integer maxFilesInBand() {
        return this.maxFilesInBand;
    }

    public final S3DirectSourceAdditionalOptions additionalOptions() {
        return this.additionalOptions;
    }

    public final Separator separator() {
        return Separator.fromValue(this.separator);
    }

    public final String separatorAsString() {
        return this.separator;
    }

    public final String escaper() {
        return this.escaper;
    }

    public final QuoteChar quoteChar() {
        return QuoteChar.fromValue(this.quoteChar);
    }

    public final String quoteCharAsString() {
        return this.quoteChar;
    }

    public final Boolean multiline() {
        return this.multiline;
    }

    public final Boolean withHeader() {
        return this.withHeader;
    }

    public final Boolean writeHeader() {
        return this.writeHeader;
    }

    public final Boolean skipFirst() {
        return this.skipFirst;
    }

    public final Boolean optimizePerformance() {
        return this.optimizePerformance;
    }

    public final boolean hasOutputSchemas() {
        return this.outputSchemas != null && !(this.outputSchemas instanceof SdkAutoConstructList);
    }

    public final List<GlueSchema> outputSchemas() {
        return this.outputSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaths() ? this.paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusions() ? this.exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.groupSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurse());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBand());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFilesInBand());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.separatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.escaper());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteCharAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiline());
        hashCode = 31 * hashCode + Objects.hashCode(this.withHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFirst());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizePerformance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSchemas() ? this.outputSchemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3CsvSource)) {
            return false;
        }
        S3CsvSource other = (S3CsvSource)obj;
        return Objects.equals(this.name(), other.name()) && this.hasPaths() == other.hasPaths() && Objects.equals(this.paths(), other.paths()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && this.hasExclusions() == other.hasExclusions() && Objects.equals(this.exclusions(), other.exclusions()) && Objects.equals(this.groupSize(), other.groupSize()) && Objects.equals(this.groupFiles(), other.groupFiles()) && Objects.equals(this.recurse(), other.recurse()) && Objects.equals(this.maxBand(), other.maxBand()) && Objects.equals(this.maxFilesInBand(), other.maxFilesInBand()) && Objects.equals(this.additionalOptions(), other.additionalOptions()) && Objects.equals(this.separatorAsString(), other.separatorAsString()) && Objects.equals(this.escaper(), other.escaper()) && Objects.equals(this.quoteCharAsString(), other.quoteCharAsString()) && Objects.equals(this.multiline(), other.multiline()) && Objects.equals(this.withHeader(), other.withHeader()) && Objects.equals(this.writeHeader(), other.writeHeader()) && Objects.equals(this.skipFirst(), other.skipFirst()) && Objects.equals(this.optimizePerformance(), other.optimizePerformance()) && this.hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(this.outputSchemas(), other.outputSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"S3CsvSource").add("Name", (Object)this.name()).add("Paths", this.hasPaths() ? this.paths() : null).add("CompressionType", (Object)this.compressionTypeAsString()).add("Exclusions", this.hasExclusions() ? this.exclusions() : null).add("GroupSize", (Object)this.groupSize()).add("GroupFiles", (Object)this.groupFiles()).add("Recurse", (Object)this.recurse()).add("MaxBand", (Object)this.maxBand()).add("MaxFilesInBand", (Object)this.maxFilesInBand()).add("AdditionalOptions", (Object)this.additionalOptions()).add("Separator", (Object)this.separatorAsString()).add("Escaper", (Object)this.escaper()).add("QuoteChar", (Object)this.quoteCharAsString()).add("Multiline", (Object)this.multiline()).add("WithHeader", (Object)this.withHeader()).add("WriteHeader", (Object)this.writeHeader()).add("SkipFirst", (Object)this.skipFirst()).add("OptimizePerformance", (Object)this.optimizePerformance()).add("OutputSchemas", this.hasOutputSchemas() ? this.outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Paths": {
                return Optional.ofNullable(clazz.cast(this.paths()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
            case "GroupSize": {
                return Optional.ofNullable(clazz.cast(this.groupSize()));
            }
            case "GroupFiles": {
                return Optional.ofNullable(clazz.cast(this.groupFiles()));
            }
            case "Recurse": {
                return Optional.ofNullable(clazz.cast(this.recurse()));
            }
            case "MaxBand": {
                return Optional.ofNullable(clazz.cast(this.maxBand()));
            }
            case "MaxFilesInBand": {
                return Optional.ofNullable(clazz.cast(this.maxFilesInBand()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
            case "Separator": {
                return Optional.ofNullable(clazz.cast(this.separatorAsString()));
            }
            case "Escaper": {
                return Optional.ofNullable(clazz.cast(this.escaper()));
            }
            case "QuoteChar": {
                return Optional.ofNullable(clazz.cast(this.quoteCharAsString()));
            }
            case "Multiline": {
                return Optional.ofNullable(clazz.cast(this.multiline()));
            }
            case "WithHeader": {
                return Optional.ofNullable(clazz.cast(this.withHeader()));
            }
            case "WriteHeader": {
                return Optional.ofNullable(clazz.cast(this.writeHeader()));
            }
            case "SkipFirst": {
                return Optional.ofNullable(clazz.cast(this.skipFirst()));
            }
            case "OptimizePerformance": {
                return Optional.ofNullable(clazz.cast(this.optimizePerformance()));
            }
            case "OutputSchemas": {
                return Optional.ofNullable(clazz.cast(this.outputSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Paths", PATHS_FIELD);
        map.put("CompressionType", COMPRESSION_TYPE_FIELD);
        map.put("Exclusions", EXCLUSIONS_FIELD);
        map.put("GroupSize", GROUP_SIZE_FIELD);
        map.put("GroupFiles", GROUP_FILES_FIELD);
        map.put("Recurse", RECURSE_FIELD);
        map.put("MaxBand", MAX_BAND_FIELD);
        map.put("MaxFilesInBand", MAX_FILES_IN_BAND_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("Separator", SEPARATOR_FIELD);
        map.put("Escaper", ESCAPER_FIELD);
        map.put("QuoteChar", QUOTE_CHAR_FIELD);
        map.put("Multiline", MULTILINE_FIELD);
        map.put("WithHeader", WITH_HEADER_FIELD);
        map.put("WriteHeader", WRITE_HEADER_FIELD);
        map.put("SkipFirst", SKIP_FIRST_FIELD);
        map.put("OptimizePerformance", OPTIMIZE_PERFORMANCE_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3CsvSource, T> g) {
        return obj -> g.apply((S3CsvSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();
        private String compressionType;
        private List<String> exclusions = DefaultSdkAutoConstructList.getInstance();
        private String groupSize;
        private String groupFiles;
        private Boolean recurse;
        private Integer maxBand;
        private Integer maxFilesInBand;
        private S3DirectSourceAdditionalOptions additionalOptions;
        private String separator;
        private String escaper;
        private String quoteChar;
        private Boolean multiline;
        private Boolean withHeader;
        private Boolean writeHeader;
        private Boolean skipFirst;
        private Boolean optimizePerformance;
        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3CsvSource model) {
            this.name(model.name);
            this.paths(model.paths);
            this.compressionType(model.compressionType);
            this.exclusions(model.exclusions);
            this.groupSize(model.groupSize);
            this.groupFiles(model.groupFiles);
            this.recurse(model.recurse);
            this.maxBand(model.maxBand);
            this.maxFilesInBand(model.maxFilesInBand);
            this.additionalOptions(model.additionalOptions);
            this.separator(model.separator);
            this.escaper(model.escaper);
            this.quoteChar(model.quoteChar);
            this.multiline(model.multiline);
            this.withHeader(model.withHeader);
            this.writeHeader(model.writeHeader);
            this.skipFirst(model.skipFirst);
            this.optimizePerformance(model.optimizePerformance);
            this.outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPaths() {
            if (this.paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = EnclosedInStringPropertiesCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = EnclosedInStringPropertiesCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String ... paths) {
            this.paths(Arrays.asList(paths));
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final Collection<String> getExclusions() {
            if (this.exclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusions;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = EnclosedInStringPropertiesCopier.copy(exclusions);
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = EnclosedInStringPropertiesCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String ... exclusions) {
            this.exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final String getGroupSize() {
            return this.groupSize;
        }

        public final void setGroupSize(String groupSize) {
            this.groupSize = groupSize;
        }

        @Override
        public final Builder groupSize(String groupSize) {
            this.groupSize = groupSize;
            return this;
        }

        public final String getGroupFiles() {
            return this.groupFiles;
        }

        public final void setGroupFiles(String groupFiles) {
            this.groupFiles = groupFiles;
        }

        @Override
        public final Builder groupFiles(String groupFiles) {
            this.groupFiles = groupFiles;
            return this;
        }

        public final Boolean getRecurse() {
            return this.recurse;
        }

        public final void setRecurse(Boolean recurse) {
            this.recurse = recurse;
        }

        @Override
        public final Builder recurse(Boolean recurse) {
            this.recurse = recurse;
            return this;
        }

        public final Integer getMaxBand() {
            return this.maxBand;
        }

        public final void setMaxBand(Integer maxBand) {
            this.maxBand = maxBand;
        }

        @Override
        public final Builder maxBand(Integer maxBand) {
            this.maxBand = maxBand;
            return this;
        }

        public final Integer getMaxFilesInBand() {
            return this.maxFilesInBand;
        }

        public final void setMaxFilesInBand(Integer maxFilesInBand) {
            this.maxFilesInBand = maxFilesInBand;
        }

        @Override
        public final Builder maxFilesInBand(Integer maxFilesInBand) {
            this.maxFilesInBand = maxFilesInBand;
            return this;
        }

        public final S3DirectSourceAdditionalOptions.Builder getAdditionalOptions() {
            return this.additionalOptions != null ? this.additionalOptions.toBuilder() : null;
        }

        public final void setAdditionalOptions(S3DirectSourceAdditionalOptions.BuilderImpl additionalOptions) {
            this.additionalOptions = additionalOptions != null ? additionalOptions.build() : null;
        }

        @Override
        public final Builder additionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        public final String getSeparator() {
            return this.separator;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        @Override
        public final Builder separator(Separator separator) {
            this.separator(separator == null ? null : separator.toString());
            return this;
        }

        public final String getEscaper() {
            return this.escaper;
        }

        public final void setEscaper(String escaper) {
            this.escaper = escaper;
        }

        @Override
        public final Builder escaper(String escaper) {
            this.escaper = escaper;
            return this;
        }

        public final String getQuoteChar() {
            return this.quoteChar;
        }

        public final void setQuoteChar(String quoteChar) {
            this.quoteChar = quoteChar;
        }

        @Override
        public final Builder quoteChar(String quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        @Override
        public final Builder quoteChar(QuoteChar quoteChar) {
            this.quoteChar(quoteChar == null ? null : quoteChar.toString());
            return this;
        }

        public final Boolean getMultiline() {
            return this.multiline;
        }

        public final void setMultiline(Boolean multiline) {
            this.multiline = multiline;
        }

        @Override
        public final Builder multiline(Boolean multiline) {
            this.multiline = multiline;
            return this;
        }

        public final Boolean getWithHeader() {
            return this.withHeader;
        }

        public final void setWithHeader(Boolean withHeader) {
            this.withHeader = withHeader;
        }

        @Override
        public final Builder withHeader(Boolean withHeader) {
            this.withHeader = withHeader;
            return this;
        }

        public final Boolean getWriteHeader() {
            return this.writeHeader;
        }

        public final void setWriteHeader(Boolean writeHeader) {
            this.writeHeader = writeHeader;
        }

        @Override
        public final Builder writeHeader(Boolean writeHeader) {
            this.writeHeader = writeHeader;
            return this;
        }

        public final Boolean getSkipFirst() {
            return this.skipFirst;
        }

        public final void setSkipFirst(Boolean skipFirst) {
            this.skipFirst = skipFirst;
        }

        @Override
        public final Builder skipFirst(Boolean skipFirst) {
            this.skipFirst = skipFirst;
            return this;
        }

        public final Boolean getOptimizePerformance() {
            return this.optimizePerformance;
        }

        public final void setOptimizePerformance(Boolean optimizePerformance) {
            this.optimizePerformance = optimizePerformance;
        }

        @Override
        public final Builder optimizePerformance(Boolean optimizePerformance) {
            this.optimizePerformance = optimizePerformance;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema ... outputSchemas) {
            this.outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder> ... outputSchemas) {
            this.outputSchemas(Stream.of(outputSchemas).map(c -> (GlueSchema)((GlueSchema.Builder)GlueSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3CsvSource build() {
            return new S3CsvSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3CsvSource> {
        public Builder name(String var1);

        public Builder paths(Collection<String> var1);

        public Builder paths(String ... var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);

        public Builder exclusions(Collection<String> var1);

        public Builder exclusions(String ... var1);

        public Builder groupSize(String var1);

        public Builder groupFiles(String var1);

        public Builder recurse(Boolean var1);

        public Builder maxBand(Integer var1);

        public Builder maxFilesInBand(Integer var1);

        public Builder additionalOptions(S3DirectSourceAdditionalOptions var1);

        default public Builder additionalOptions(Consumer<S3DirectSourceAdditionalOptions.Builder> additionalOptions) {
            return this.additionalOptions((S3DirectSourceAdditionalOptions)((S3DirectSourceAdditionalOptions.Builder)S3DirectSourceAdditionalOptions.builder().applyMutation(additionalOptions)).build());
        }

        public Builder separator(String var1);

        public Builder separator(Separator var1);

        public Builder escaper(String var1);

        public Builder quoteChar(String var1);

        public Builder quoteChar(QuoteChar var1);

        public Builder multiline(Boolean var1);

        public Builder withHeader(Boolean var1);

        public Builder writeHeader(Boolean var1);

        public Builder skipFirst(Boolean var1);

        public Builder optimizePerformance(Boolean var1);

        public Builder outputSchemas(Collection<GlueSchema> var1);

        public Builder outputSchemas(GlueSchema ... var1);

        public Builder outputSchemas(Consumer<GlueSchema.Builder> ... var1);
    }
}

