/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.RegistryListDefinitionCopier;
import software.amazon.awssdk.services.glue.model.RegistryListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegistriesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListRegistriesResponse> {
    private static final SdkField<List<RegistryListItem>> REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Registries").getter(ListRegistriesResponse.getter(ListRegistriesResponse::registries)).setter(ListRegistriesResponse.setter(Builder::registries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistryListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegistriesResponse.getter(ListRegistriesResponse::nextToken)).setter(ListRegistriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRegistriesResponse.memberNameToFieldInitializer();
    private final List<RegistryListItem> registries;
    private final String nextToken;

    private ListRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.registries = builder.registries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRegistries() {
        return this.registries != null && !(this.registries instanceof SdkAutoConstructList);
    }

    public final List<RegistryListItem> registries() {
        return this.registries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistries() ? this.registries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistriesResponse)) {
            return false;
        }
        ListRegistriesResponse other = (ListRegistriesResponse)((Object)obj);
        return this.hasRegistries() == other.hasRegistries() && Objects.equals(this.registries(), other.registries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegistriesResponse").add("Registries", this.hasRegistries() ? this.registries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Registries": {
                return Optional.ofNullable(clazz.cast(this.registries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Registries", REGISTRIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegistriesResponse, T> g) {
        return obj -> g.apply((ListRegistriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<RegistryListItem> registries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistriesResponse model) {
            super(model);
            this.registries(model.registries);
            this.nextToken(model.nextToken);
        }

        public final List<RegistryListItem.Builder> getRegistries() {
            List<RegistryListItem.Builder> result = RegistryListDefinitionCopier.copyToBuilder(this.registries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistries(Collection<RegistryListItem.BuilderImpl> registries) {
            this.registries = RegistryListDefinitionCopier.copyFromBuilder(registries);
        }

        @Override
        public final Builder registries(Collection<RegistryListItem> registries) {
            this.registries = RegistryListDefinitionCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(RegistryListItem ... registries) {
            this.registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<RegistryListItem.Builder> ... registries) {
            this.registries(Stream.of(registries).map(c -> (RegistryListItem)((RegistryListItem.Builder)RegistryListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRegistriesResponse build() {
            return new ListRegistriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegistriesResponse> {
        public Builder registries(Collection<RegistryListItem> var1);

        public Builder registries(RegistryListItem ... var1);

        public Builder registries(Consumer<RegistryListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

