/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FunctionType {
    REGULAR_FUNCTION("REGULAR_FUNCTION"),
    AGGREGATE_FUNCTION("AGGREGATE_FUNCTION"),
    STORED_PROCEDURE("STORED_PROCEDURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FunctionType> VALUE_MAP;
    private final String value;

    private FunctionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FunctionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FunctionType> knownValues() {
        EnumSet<FunctionType> knownValues = EnumSet.allOf(FunctionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FunctionType.class, FunctionType::toString);
    }
}

