/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DataQualityRuleResultStatus;
import software.amazon.awssdk.services.glue.model.EvaluatedMetricsMapCopier;
import software.amazon.awssdk.services.glue.model.LabelsCopier;
import software.amazon.awssdk.services.glue.model.RuleMetricsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityRuleResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityRuleResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataQualityRuleResult.getter(DataQualityRuleResult::name)).setter(DataQualityRuleResult.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataQualityRuleResult.getter(DataQualityRuleResult::description)).setter(DataQualityRuleResult.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EVALUATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMessage").getter(DataQualityRuleResult.getter(DataQualityRuleResult::evaluationMessage)).setter(DataQualityRuleResult.setter(Builder::evaluationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMessage").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Result").getter(DataQualityRuleResult.getter(DataQualityRuleResult::resultAsString)).setter(DataQualityRuleResult.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final SdkField<Map<String, Double>> EVALUATED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EvaluatedMetrics").getter(DataQualityRuleResult.getter(DataQualityRuleResult::evaluatedMetrics)).setter(DataQualityRuleResult.setter(Builder::evaluatedMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATED_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatedRule").getter(DataQualityRuleResult.getter(DataQualityRuleResult::evaluatedRule)).setter(DataQualityRuleResult.setter(Builder::evaluatedRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedRule").build()}).build();
    private static final SdkField<Map<String, Double>> RULE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RuleMetrics").getter(DataQualityRuleResult.getter(DataQualityRuleResult::ruleMetrics)).setter(DataQualityRuleResult.setter(Builder::ruleMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Labels").getter(DataQualityRuleResult.getter(DataQualityRuleResult::labels)).setter(DataQualityRuleResult.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, EVALUATION_MESSAGE_FIELD, RESULT_FIELD, EVALUATED_METRICS_FIELD, EVALUATED_RULE_FIELD, RULE_METRICS_FIELD, LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityRuleResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String evaluationMessage;
    private final String result;
    private final Map<String, Double> evaluatedMetrics;
    private final String evaluatedRule;
    private final Map<String, Double> ruleMetrics;
    private final Map<String, String> labels;

    private DataQualityRuleResult(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.evaluationMessage = builder.evaluationMessage;
        this.result = builder.result;
        this.evaluatedMetrics = builder.evaluatedMetrics;
        this.evaluatedRule = builder.evaluatedRule;
        this.ruleMetrics = builder.ruleMetrics;
        this.labels = builder.labels;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String evaluationMessage() {
        return this.evaluationMessage;
    }

    public final DataQualityRuleResultStatus result() {
        return DataQualityRuleResultStatus.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final boolean hasEvaluatedMetrics() {
        return this.evaluatedMetrics != null && !(this.evaluatedMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> evaluatedMetrics() {
        return this.evaluatedMetrics;
    }

    public final String evaluatedRule() {
        return this.evaluatedRule;
    }

    public final boolean hasRuleMetrics() {
        return this.ruleMetrics != null && !(this.ruleMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> ruleMetrics() {
        return this.ruleMetrics;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluatedMetrics() ? this.evaluatedMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatedRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleMetrics() ? this.ruleMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRuleResult)) {
            return false;
        }
        DataQualityRuleResult other = (DataQualityRuleResult)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.evaluationMessage(), other.evaluationMessage()) && Objects.equals(this.resultAsString(), other.resultAsString()) && this.hasEvaluatedMetrics() == other.hasEvaluatedMetrics() && Objects.equals(this.evaluatedMetrics(), other.evaluatedMetrics()) && Objects.equals(this.evaluatedRule(), other.evaluatedRule()) && this.hasRuleMetrics() == other.hasRuleMetrics() && Objects.equals(this.ruleMetrics(), other.ruleMetrics()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityRuleResult").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EvaluationMessage", (Object)(this.evaluationMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("Result", (Object)this.resultAsString()).add("EvaluatedMetrics", (Object)(this.evaluatedMetrics() == null ? null : "*** Sensitive Data Redacted ***")).add("EvaluatedRule", (Object)(this.evaluatedRule() == null ? null : "*** Sensitive Data Redacted ***")).add("RuleMetrics", (Object)(this.ruleMetrics() == null ? null : "*** Sensitive Data Redacted ***")).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EvaluationMessage": {
                return Optional.ofNullable(clazz.cast(this.evaluationMessage()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "EvaluatedMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluatedMetrics()));
            }
            case "EvaluatedRule": {
                return Optional.ofNullable(clazz.cast(this.evaluatedRule()));
            }
            case "RuleMetrics": {
                return Optional.ofNullable(clazz.cast(this.ruleMetrics()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EvaluationMessage", EVALUATION_MESSAGE_FIELD);
        map.put("Result", RESULT_FIELD);
        map.put("EvaluatedMetrics", EVALUATED_METRICS_FIELD);
        map.put("EvaluatedRule", EVALUATED_RULE_FIELD);
        map.put("RuleMetrics", RULE_METRICS_FIELD);
        map.put("Labels", LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRuleResult, T> g) {
        return obj -> g.apply((DataQualityRuleResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String evaluationMessage;
        private String result;
        private Map<String, Double> evaluatedMetrics = DefaultSdkAutoConstructMap.getInstance();
        private String evaluatedRule;
        private Map<String, Double> ruleMetrics = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRuleResult model) {
            this.name(model.name);
            this.description(model.description);
            this.evaluationMessage(model.evaluationMessage);
            this.result(model.result);
            this.evaluatedMetrics(model.evaluatedMetrics);
            this.evaluatedRule(model.evaluatedRule);
            this.ruleMetrics(model.ruleMetrics);
            this.labels(model.labels);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEvaluationMessage() {
            return this.evaluationMessage;
        }

        public final void setEvaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
        }

        @Override
        public final Builder evaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(DataQualityRuleResultStatus result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final Map<String, Double> getEvaluatedMetrics() {
            if (this.evaluatedMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.evaluatedMetrics;
        }

        public final void setEvaluatedMetrics(Map<String, Double> evaluatedMetrics) {
            this.evaluatedMetrics = EvaluatedMetricsMapCopier.copy(evaluatedMetrics);
        }

        @Override
        public final Builder evaluatedMetrics(Map<String, Double> evaluatedMetrics) {
            this.evaluatedMetrics = EvaluatedMetricsMapCopier.copy(evaluatedMetrics);
            return this;
        }

        public final String getEvaluatedRule() {
            return this.evaluatedRule;
        }

        public final void setEvaluatedRule(String evaluatedRule) {
            this.evaluatedRule = evaluatedRule;
        }

        @Override
        public final Builder evaluatedRule(String evaluatedRule) {
            this.evaluatedRule = evaluatedRule;
            return this;
        }

        public final Map<String, Double> getRuleMetrics() {
            if (this.ruleMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.ruleMetrics;
        }

        public final void setRuleMetrics(Map<String, Double> ruleMetrics) {
            this.ruleMetrics = RuleMetricsMapCopier.copy(ruleMetrics);
        }

        @Override
        public final Builder ruleMetrics(Map<String, Double> ruleMetrics) {
            this.ruleMetrics = RuleMetricsMapCopier.copy(ruleMetrics);
            return this;
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = LabelsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        public DataQualityRuleResult build() {
            return new DataQualityRuleResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityRuleResult> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder evaluationMessage(String var1);

        public Builder result(String var1);

        public Builder result(DataQualityRuleResultStatus var1);

        public Builder evaluatedMetrics(Map<String, Double> var1);

        public Builder evaluatedRule(String var1);

        public Builder ruleMetrics(Map<String, Double> var1);

        public Builder labels(Map<String, String> var1);
    }
}

