/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionType {
    JDBC("JDBC"),
    SFTP("SFTP"),
    MONGODB("MONGODB"),
    KAFKA("KAFKA"),
    NETWORK("NETWORK"),
    MARKETPLACE("MARKETPLACE"),
    CUSTOM("CUSTOM"),
    SALESFORCE("SALESFORCE"),
    VIEW_VALIDATION_REDSHIFT("VIEW_VALIDATION_REDSHIFT"),
    VIEW_VALIDATION_ATHENA("VIEW_VALIDATION_ATHENA"),
    GOOGLEADS("GOOGLEADS"),
    GOOGLESHEETS("GOOGLESHEETS"),
    GOOGLEANALYTICS4("GOOGLEANALYTICS4"),
    SERVICENOW("SERVICENOW"),
    MARKETO("MARKETO"),
    SAPODATA("SAPODATA"),
    ZENDESK("ZENDESK"),
    JIRACLOUD("JIRACLOUD"),
    NETSUITEERP("NETSUITEERP"),
    HUBSPOT("HUBSPOT"),
    FACEBOOKADS("FACEBOOKADS"),
    INSTAGRAMADS("INSTAGRAMADS"),
    ZOHOCRM("ZOHOCRM"),
    SALESFORCEPARDOT("SALESFORCEPARDOT"),
    SALESFORCEMARKETINGCLOUD("SALESFORCEMARKETINGCLOUD"),
    ADOBEANALYTICS("ADOBEANALYTICS"),
    SLACK("SLACK"),
    LINKEDIN("LINKEDIN"),
    MIXPANEL("MIXPANEL"),
    ASANA("ASANA"),
    STRIPE("STRIPE"),
    SMARTSHEET("SMARTSHEET"),
    DATADOG("DATADOG"),
    WOOCOMMERCE("WOOCOMMERCE"),
    INTERCOM("INTERCOM"),
    SNAPCHATADS("SNAPCHATADS"),
    PAYPAL("PAYPAL"),
    QUICKBOOKS("QUICKBOOKS"),
    FACEBOOKPAGEINSIGHTS("FACEBOOKPAGEINSIGHTS"),
    FRESHDESK("FRESHDESK"),
    TWILIO("TWILIO"),
    DOCUSIGNMONITOR("DOCUSIGNMONITOR"),
    FRESHSALES("FRESHSALES"),
    ZOOM("ZOOM"),
    GOOGLESEARCHCONSOLE("GOOGLESEARCHCONSOLE"),
    SALESFORCECOMMERCECLOUD("SALESFORCECOMMERCECLOUD"),
    SAPCONCUR("SAPCONCUR"),
    DYNATRACE("DYNATRACE"),
    MICROSOFTDYNAMIC365_FINANCEANDOPS("MICROSOFTDYNAMIC365FINANCEANDOPS"),
    MICROSOFTTEAMS("MICROSOFTTEAMS"),
    BLACKBAUDRAISEREDGENXT("BLACKBAUDRAISEREDGENXT"),
    MAILCHIMP("MAILCHIMP"),
    GITLAB("GITLAB"),
    PENDO("PENDO"),
    PRODUCTBOARD("PRODUCTBOARD"),
    CIRCLECI("CIRCLECI"),
    PIPEDIVE("PIPEDIVE"),
    SENDGRID("SENDGRID"),
    AZURECOSMOS("AZURECOSMOS"),
    AZURESQL("AZURESQL"),
    BIGQUERY("BIGQUERY"),
    BLACKBAUD("BLACKBAUD"),
    CLOUDERAHIVE("CLOUDERAHIVE"),
    CLOUDERAIMPALA("CLOUDERAIMPALA"),
    CLOUDWATCH("CLOUDWATCH"),
    CLOUDWATCHMETRICS("CLOUDWATCHMETRICS"),
    CMDB("CMDB"),
    DATALAKEGEN2("DATALAKEGEN2"),
    DB2("DB2"),
    DB2_AS400("DB2AS400"),
    DOCUMENTDB("DOCUMENTDB"),
    DOMO("DOMO"),
    DYNAMODB("DYNAMODB"),
    GOOGLECLOUDSTORAGE("GOOGLECLOUDSTORAGE"),
    HBASE("HBASE"),
    KUSTOMER("KUSTOMER"),
    MICROSOFTDYNAMICS365_CRM("MICROSOFTDYNAMICS365CRM"),
    MONDAY("MONDAY"),
    MYSQL("MYSQL"),
    OKTA("OKTA"),
    OPENSEARCH("OPENSEARCH"),
    ORACLE("ORACLE"),
    PIPEDRIVE("PIPEDRIVE"),
    POSTGRESQL("POSTGRESQL"),
    SAPHANA("SAPHANA"),
    SQLSERVER("SQLSERVER"),
    SYNAPSE("SYNAPSE"),
    TERADATA("TERADATA"),
    TERADATANOS("TERADATANOS"),
    TIMESTREAM("TIMESTREAM"),
    TPCDS("TPCDS"),
    VERTICA("VERTICA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionType> VALUE_MAP;
    private final String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionType> knownValues() {
        EnumSet<ConnectionType> knownValues = EnumSet.allOf(ConnectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionType.class, ConnectionType::toString);
    }
}

