/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CompactionConfiguration;
import software.amazon.awssdk.services.glue.model.OrphanFileDeletionConfiguration;
import software.amazon.awssdk.services.glue.model.RetentionConfiguration;
import software.amazon.awssdk.services.glue.model.TableOptimizerVpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableOptimizerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableOptimizerConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(TableOptimizerConfiguration.getter(TableOptimizerConfiguration::roleArn)).setter(TableOptimizerConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(TableOptimizerConfiguration.getter(TableOptimizerConfiguration::enabled)).setter(TableOptimizerConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<TableOptimizerVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(TableOptimizerConfiguration.getter(TableOptimizerConfiguration::vpcConfiguration)).setter(TableOptimizerConfiguration.setter(Builder::vpcConfiguration)).constructor(TableOptimizerVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<CompactionConfiguration> COMPACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compactionConfiguration").getter(TableOptimizerConfiguration.getter(TableOptimizerConfiguration::compactionConfiguration)).setter(TableOptimizerConfiguration.setter(Builder::compactionConfiguration)).constructor(CompactionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionConfiguration").build()}).build();
    private static final SdkField<RetentionConfiguration> RETENTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionConfiguration").getter(TableOptimizerConfiguration.getter(TableOptimizerConfiguration::retentionConfiguration)).setter(TableOptimizerConfiguration.setter(Builder::retentionConfiguration)).constructor(RetentionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionConfiguration").build()}).build();
    private static final SdkField<OrphanFileDeletionConfiguration> ORPHAN_FILE_DELETION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orphanFileDeletionConfiguration").getter(TableOptimizerConfiguration.getter(TableOptimizerConfiguration::orphanFileDeletionConfiguration)).setter(TableOptimizerConfiguration.setter(Builder::orphanFileDeletionConfiguration)).constructor(OrphanFileDeletionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanFileDeletionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, ENABLED_FIELD, VPC_CONFIGURATION_FIELD, COMPACTION_CONFIGURATION_FIELD, RETENTION_CONFIGURATION_FIELD, ORPHAN_FILE_DELETION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableOptimizerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final Boolean enabled;
    private final TableOptimizerVpcConfiguration vpcConfiguration;
    private final CompactionConfiguration compactionConfiguration;
    private final RetentionConfiguration retentionConfiguration;
    private final OrphanFileDeletionConfiguration orphanFileDeletionConfiguration;

    private TableOptimizerConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.enabled = builder.enabled;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.compactionConfiguration = builder.compactionConfiguration;
        this.retentionConfiguration = builder.retentionConfiguration;
        this.orphanFileDeletionConfiguration = builder.orphanFileDeletionConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final TableOptimizerVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final CompactionConfiguration compactionConfiguration() {
        return this.compactionConfiguration;
    }

    public final RetentionConfiguration retentionConfiguration() {
        return this.retentionConfiguration;
    }

    public final OrphanFileDeletionConfiguration orphanFileDeletionConfiguration() {
        return this.orphanFileDeletionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.compactionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.orphanFileDeletionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizerConfiguration)) {
            return false;
        }
        TableOptimizerConfiguration other = (TableOptimizerConfiguration)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.compactionConfiguration(), other.compactionConfiguration()) && Objects.equals(this.retentionConfiguration(), other.retentionConfiguration()) && Objects.equals(this.orphanFileDeletionConfiguration(), other.orphanFileDeletionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TableOptimizerConfiguration").add("RoleArn", (Object)this.roleArn()).add("Enabled", (Object)this.enabled()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("CompactionConfiguration", (Object)this.compactionConfiguration()).add("RetentionConfiguration", (Object)this.retentionConfiguration()).add("OrphanFileDeletionConfiguration", (Object)this.orphanFileDeletionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "compactionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.compactionConfiguration()));
            }
            case "retentionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retentionConfiguration()));
            }
            case "orphanFileDeletionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.orphanFileDeletionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("compactionConfiguration", COMPACTION_CONFIGURATION_FIELD);
        map.put("retentionConfiguration", RETENTION_CONFIGURATION_FIELD);
        map.put("orphanFileDeletionConfiguration", ORPHAN_FILE_DELETION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizerConfiguration, T> g) {
        return obj -> g.apply((TableOptimizerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private Boolean enabled;
        private TableOptimizerVpcConfiguration vpcConfiguration;
        private CompactionConfiguration compactionConfiguration;
        private RetentionConfiguration retentionConfiguration;
        private OrphanFileDeletionConfiguration orphanFileDeletionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizerConfiguration model) {
            this.roleArn(model.roleArn);
            this.enabled(model.enabled);
            this.vpcConfiguration(model.vpcConfiguration);
            this.compactionConfiguration(model.compactionConfiguration);
            this.retentionConfiguration(model.retentionConfiguration);
            this.orphanFileDeletionConfiguration(model.orphanFileDeletionConfiguration);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final TableOptimizerVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(TableOptimizerVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(TableOptimizerVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final CompactionConfiguration.Builder getCompactionConfiguration() {
            return this.compactionConfiguration != null ? this.compactionConfiguration.toBuilder() : null;
        }

        public final void setCompactionConfiguration(CompactionConfiguration.BuilderImpl compactionConfiguration) {
            this.compactionConfiguration = compactionConfiguration != null ? compactionConfiguration.build() : null;
        }

        @Override
        public final Builder compactionConfiguration(CompactionConfiguration compactionConfiguration) {
            this.compactionConfiguration = compactionConfiguration;
            return this;
        }

        public final RetentionConfiguration.Builder getRetentionConfiguration() {
            return this.retentionConfiguration != null ? this.retentionConfiguration.toBuilder() : null;
        }

        public final void setRetentionConfiguration(RetentionConfiguration.BuilderImpl retentionConfiguration) {
            this.retentionConfiguration = retentionConfiguration != null ? retentionConfiguration.build() : null;
        }

        @Override
        public final Builder retentionConfiguration(RetentionConfiguration retentionConfiguration) {
            this.retentionConfiguration = retentionConfiguration;
            return this;
        }

        public final OrphanFileDeletionConfiguration.Builder getOrphanFileDeletionConfiguration() {
            return this.orphanFileDeletionConfiguration != null ? this.orphanFileDeletionConfiguration.toBuilder() : null;
        }

        public final void setOrphanFileDeletionConfiguration(OrphanFileDeletionConfiguration.BuilderImpl orphanFileDeletionConfiguration) {
            this.orphanFileDeletionConfiguration = orphanFileDeletionConfiguration != null ? orphanFileDeletionConfiguration.build() : null;
        }

        @Override
        public final Builder orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration orphanFileDeletionConfiguration) {
            this.orphanFileDeletionConfiguration = orphanFileDeletionConfiguration;
            return this;
        }

        public TableOptimizerConfiguration build() {
            return new TableOptimizerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableOptimizerConfiguration> {
        public Builder roleArn(String var1);

        public Builder enabled(Boolean var1);

        public Builder vpcConfiguration(TableOptimizerVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<TableOptimizerVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((TableOptimizerVpcConfiguration)((TableOptimizerVpcConfiguration.Builder)TableOptimizerVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder compactionConfiguration(CompactionConfiguration var1);

        default public Builder compactionConfiguration(Consumer<CompactionConfiguration.Builder> compactionConfiguration) {
            return this.compactionConfiguration((CompactionConfiguration)((CompactionConfiguration.Builder)CompactionConfiguration.builder().applyMutation(compactionConfiguration)).build());
        }

        public Builder retentionConfiguration(RetentionConfiguration var1);

        default public Builder retentionConfiguration(Consumer<RetentionConfiguration.Builder> retentionConfiguration) {
            return this.retentionConfiguration((RetentionConfiguration)((RetentionConfiguration.Builder)RetentionConfiguration.builder().applyMutation(retentionConfiguration)).build());
        }

        public Builder orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration var1);

        default public Builder orphanFileDeletionConfiguration(Consumer<OrphanFileDeletionConfiguration.Builder> orphanFileDeletionConfiguration) {
            return this.orphanFileDeletionConfiguration((OrphanFileDeletionConfiguration)((OrphanFileDeletionConfiguration.Builder)OrphanFileDeletionConfiguration.builder().applyMutation(orphanFileDeletionConfiguration)).build());
        }
    }
}

