/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DataQualityAggregatedMetrics;
import software.amazon.awssdk.services.glue.model.DataQualityAnalyzerResult;
import software.amazon.awssdk.services.glue.model.DataQualityAnalyzerResultsCopier;
import software.amazon.awssdk.services.glue.model.DataQualityObservation;
import software.amazon.awssdk.services.glue.model.DataQualityObservationsCopier;
import software.amazon.awssdk.services.glue.model.DataQualityRuleResult;
import software.amazon.awssdk.services.glue.model.DataQualityRuleResultsCopier;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataQualityResultResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataQualityResultResponse> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultId").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::resultId)).setter(GetDataQualityResultResponse.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::profileId)).setter(GetDataQualityResultResponse.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Score").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::score)).setter(GetDataQualityResultResponse.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::dataSource)).setter(GetDataQualityResultResponse.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> RULESET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RulesetName").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::rulesetName)).setter(GetDataQualityResultResponse.setter(Builder::rulesetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetName").build()}).build();
    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationContext").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::evaluationContext)).setter(GetDataQualityResultResponse.setter(Builder::evaluationContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::startedOn)).setter(GetDataQualityResultResponse.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::completedOn)).setter(GetDataQualityResultResponse.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::jobName)).setter(GetDataQualityResultResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobRunId").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::jobRunId)).setter(GetDataQualityResultResponse.setter(Builder::jobRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()}).build();
    private static final SdkField<String> RULESET_EVALUATION_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RulesetEvaluationRunId").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::rulesetEvaluationRunId)).setter(GetDataQualityResultResponse.setter(Builder::rulesetEvaluationRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetEvaluationRunId").build()}).build();
    private static final SdkField<List<DataQualityRuleResult>> RULE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleResults").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::ruleResults)).setter(GetDataQualityResultResponse.setter(Builder::ruleResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityRuleResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataQualityAnalyzerResult>> ANALYZER_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalyzerResults").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::analyzerResults)).setter(GetDataQualityResultResponse.setter(Builder::analyzerResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzerResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityAnalyzerResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataQualityObservation>> OBSERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Observations").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::observations)).setter(GetDataQualityResultResponse.setter(Builder::observations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Observations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityObservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataQualityAggregatedMetrics> AGGREGATED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregatedMetrics").getter(GetDataQualityResultResponse.getter(GetDataQualityResultResponse::aggregatedMetrics)).setter(GetDataQualityResultResponse.setter(Builder::aggregatedMetrics)).constructor(DataQualityAggregatedMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatedMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD, PROFILE_ID_FIELD, SCORE_FIELD, DATA_SOURCE_FIELD, RULESET_NAME_FIELD, EVALUATION_CONTEXT_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD, JOB_NAME_FIELD, JOB_RUN_ID_FIELD, RULESET_EVALUATION_RUN_ID_FIELD, RULE_RESULTS_FIELD, ANALYZER_RESULTS_FIELD, OBSERVATIONS_FIELD, AGGREGATED_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataQualityResultResponse.memberNameToFieldInitializer();
    private final String resultId;
    private final String profileId;
    private final Double score;
    private final DataSource dataSource;
    private final String rulesetName;
    private final String evaluationContext;
    private final Instant startedOn;
    private final Instant completedOn;
    private final String jobName;
    private final String jobRunId;
    private final String rulesetEvaluationRunId;
    private final List<DataQualityRuleResult> ruleResults;
    private final List<DataQualityAnalyzerResult> analyzerResults;
    private final List<DataQualityObservation> observations;
    private final DataQualityAggregatedMetrics aggregatedMetrics;

    private GetDataQualityResultResponse(BuilderImpl builder) {
        super(builder);
        this.resultId = builder.resultId;
        this.profileId = builder.profileId;
        this.score = builder.score;
        this.dataSource = builder.dataSource;
        this.rulesetName = builder.rulesetName;
        this.evaluationContext = builder.evaluationContext;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.rulesetEvaluationRunId = builder.rulesetEvaluationRunId;
        this.ruleResults = builder.ruleResults;
        this.analyzerResults = builder.analyzerResults;
        this.observations = builder.observations;
        this.aggregatedMetrics = builder.aggregatedMetrics;
    }

    public final String resultId() {
        return this.resultId;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final Double score() {
        return this.score;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String rulesetName() {
        return this.rulesetName;
    }

    public final String evaluationContext() {
        return this.evaluationContext;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobRunId() {
        return this.jobRunId;
    }

    public final String rulesetEvaluationRunId() {
        return this.rulesetEvaluationRunId;
    }

    public final boolean hasRuleResults() {
        return this.ruleResults != null && !(this.ruleResults instanceof SdkAutoConstructList);
    }

    public final List<DataQualityRuleResult> ruleResults() {
        return this.ruleResults;
    }

    public final boolean hasAnalyzerResults() {
        return this.analyzerResults != null && !(this.analyzerResults instanceof SdkAutoConstructList);
    }

    public final List<DataQualityAnalyzerResult> analyzerResults() {
        return this.analyzerResults;
    }

    public final boolean hasObservations() {
        return this.observations != null && !(this.observations instanceof SdkAutoConstructList);
    }

    public final List<DataQualityObservation> observations() {
        return this.observations;
    }

    public final DataQualityAggregatedMetrics aggregatedMetrics() {
        return this.aggregatedMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesetEvaluationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleResults() ? this.ruleResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalyzerResults() ? this.analyzerResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObservations() ? this.observations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityResultResponse)) {
            return false;
        }
        GetDataQualityResultResponse other = (GetDataQualityResultResponse)((Object)obj);
        return Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.rulesetName(), other.rulesetName()) && Objects.equals(this.evaluationContext(), other.evaluationContext()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunId(), other.jobRunId()) && Objects.equals(this.rulesetEvaluationRunId(), other.rulesetEvaluationRunId()) && this.hasRuleResults() == other.hasRuleResults() && Objects.equals(this.ruleResults(), other.ruleResults()) && this.hasAnalyzerResults() == other.hasAnalyzerResults() && Objects.equals(this.analyzerResults(), other.analyzerResults()) && this.hasObservations() == other.hasObservations() && Objects.equals(this.observations(), other.observations()) && Objects.equals(this.aggregatedMetrics(), other.aggregatedMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataQualityResultResponse").add("ResultId", (Object)this.resultId()).add("ProfileId", (Object)this.profileId()).add("Score", (Object)this.score()).add("DataSource", (Object)this.dataSource()).add("RulesetName", (Object)this.rulesetName()).add("EvaluationContext", (Object)this.evaluationContext()).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).add("JobName", (Object)this.jobName()).add("JobRunId", (Object)this.jobRunId()).add("RulesetEvaluationRunId", (Object)this.rulesetEvaluationRunId()).add("RuleResults", this.hasRuleResults() ? this.ruleResults() : null).add("AnalyzerResults", this.hasAnalyzerResults() ? this.analyzerResults() : null).add("Observations", this.hasObservations() ? this.observations() : null).add("AggregatedMetrics", (Object)this.aggregatedMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "RulesetName": {
                return Optional.ofNullable(clazz.cast(this.rulesetName()));
            }
            case "EvaluationContext": {
                return Optional.ofNullable(clazz.cast(this.evaluationContext()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "RulesetEvaluationRunId": {
                return Optional.ofNullable(clazz.cast(this.rulesetEvaluationRunId()));
            }
            case "RuleResults": {
                return Optional.ofNullable(clazz.cast(this.ruleResults()));
            }
            case "AnalyzerResults": {
                return Optional.ofNullable(clazz.cast(this.analyzerResults()));
            }
            case "Observations": {
                return Optional.ofNullable(clazz.cast(this.observations()));
            }
            case "AggregatedMetrics": {
                return Optional.ofNullable(clazz.cast(this.aggregatedMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultId", RESULT_ID_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("Score", SCORE_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("RulesetName", RULESET_NAME_FIELD);
        map.put("EvaluationContext", EVALUATION_CONTEXT_FIELD);
        map.put("StartedOn", STARTED_ON_FIELD);
        map.put("CompletedOn", COMPLETED_ON_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobRunId", JOB_RUN_ID_FIELD);
        map.put("RulesetEvaluationRunId", RULESET_EVALUATION_RUN_ID_FIELD);
        map.put("RuleResults", RULE_RESULTS_FIELD);
        map.put("AnalyzerResults", ANALYZER_RESULTS_FIELD);
        map.put("Observations", OBSERVATIONS_FIELD);
        map.put("AggregatedMetrics", AGGREGATED_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityResultResponse, T> g) {
        return obj -> g.apply((GetDataQualityResultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String resultId;
        private String profileId;
        private Double score;
        private DataSource dataSource;
        private String rulesetName;
        private String evaluationContext;
        private Instant startedOn;
        private Instant completedOn;
        private String jobName;
        private String jobRunId;
        private String rulesetEvaluationRunId;
        private List<DataQualityRuleResult> ruleResults = DefaultSdkAutoConstructList.getInstance();
        private List<DataQualityAnalyzerResult> analyzerResults = DefaultSdkAutoConstructList.getInstance();
        private List<DataQualityObservation> observations = DefaultSdkAutoConstructList.getInstance();
        private DataQualityAggregatedMetrics aggregatedMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityResultResponse model) {
            super(model);
            this.resultId(model.resultId);
            this.profileId(model.profileId);
            this.score(model.score);
            this.dataSource(model.dataSource);
            this.rulesetName(model.rulesetName);
            this.evaluationContext(model.evaluationContext);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
            this.jobName(model.jobName);
            this.jobRunId(model.jobRunId);
            this.rulesetEvaluationRunId(model.rulesetEvaluationRunId);
            this.ruleResults(model.ruleResults);
            this.analyzerResults(model.analyzerResults);
            this.observations(model.observations);
            this.aggregatedMetrics(model.aggregatedMetrics);
        }

        public final String getResultId() {
            return this.resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRulesetName() {
            return this.rulesetName;
        }

        public final void setRulesetName(String rulesetName) {
            this.rulesetName = rulesetName;
        }

        @Override
        public final Builder rulesetName(String rulesetName) {
            this.rulesetName = rulesetName;
            return this;
        }

        public final String getEvaluationContext() {
            return this.evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final String getRulesetEvaluationRunId() {
            return this.rulesetEvaluationRunId;
        }

        public final void setRulesetEvaluationRunId(String rulesetEvaluationRunId) {
            this.rulesetEvaluationRunId = rulesetEvaluationRunId;
        }

        @Override
        public final Builder rulesetEvaluationRunId(String rulesetEvaluationRunId) {
            this.rulesetEvaluationRunId = rulesetEvaluationRunId;
            return this;
        }

        public final List<DataQualityRuleResult.Builder> getRuleResults() {
            List<DataQualityRuleResult.Builder> result = DataQualityRuleResultsCopier.copyToBuilder(this.ruleResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleResults(Collection<DataQualityRuleResult.BuilderImpl> ruleResults) {
            this.ruleResults = DataQualityRuleResultsCopier.copyFromBuilder(ruleResults);
        }

        @Override
        public final Builder ruleResults(Collection<DataQualityRuleResult> ruleResults) {
            this.ruleResults = DataQualityRuleResultsCopier.copy(ruleResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(DataQualityRuleResult ... ruleResults) {
            this.ruleResults(Arrays.asList(ruleResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(Consumer<DataQualityRuleResult.Builder> ... ruleResults) {
            this.ruleResults(Stream.of(ruleResults).map(c -> (DataQualityRuleResult)((DataQualityRuleResult.Builder)DataQualityRuleResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataQualityAnalyzerResult.Builder> getAnalyzerResults() {
            List<DataQualityAnalyzerResult.Builder> result = DataQualityAnalyzerResultsCopier.copyToBuilder(this.analyzerResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyzerResults(Collection<DataQualityAnalyzerResult.BuilderImpl> analyzerResults) {
            this.analyzerResults = DataQualityAnalyzerResultsCopier.copyFromBuilder(analyzerResults);
        }

        @Override
        public final Builder analyzerResults(Collection<DataQualityAnalyzerResult> analyzerResults) {
            this.analyzerResults = DataQualityAnalyzerResultsCopier.copy(analyzerResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzerResults(DataQualityAnalyzerResult ... analyzerResults) {
            this.analyzerResults(Arrays.asList(analyzerResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzerResults(Consumer<DataQualityAnalyzerResult.Builder> ... analyzerResults) {
            this.analyzerResults(Stream.of(analyzerResults).map(c -> (DataQualityAnalyzerResult)((DataQualityAnalyzerResult.Builder)DataQualityAnalyzerResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataQualityObservation.Builder> getObservations() {
            List<DataQualityObservation.Builder> result = DataQualityObservationsCopier.copyToBuilder(this.observations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObservations(Collection<DataQualityObservation.BuilderImpl> observations) {
            this.observations = DataQualityObservationsCopier.copyFromBuilder(observations);
        }

        @Override
        public final Builder observations(Collection<DataQualityObservation> observations) {
            this.observations = DataQualityObservationsCopier.copy(observations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observations(DataQualityObservation ... observations) {
            this.observations(Arrays.asList(observations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observations(Consumer<DataQualityObservation.Builder> ... observations) {
            this.observations(Stream.of(observations).map(c -> (DataQualityObservation)((DataQualityObservation.Builder)DataQualityObservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataQualityAggregatedMetrics.Builder getAggregatedMetrics() {
            return this.aggregatedMetrics != null ? this.aggregatedMetrics.toBuilder() : null;
        }

        public final void setAggregatedMetrics(DataQualityAggregatedMetrics.BuilderImpl aggregatedMetrics) {
            this.aggregatedMetrics = aggregatedMetrics != null ? aggregatedMetrics.build() : null;
        }

        @Override
        public final Builder aggregatedMetrics(DataQualityAggregatedMetrics aggregatedMetrics) {
            this.aggregatedMetrics = aggregatedMetrics;
            return this;
        }

        @Override
        public GetDataQualityResultResponse build() {
            return new GetDataQualityResultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataQualityResultResponse> {
        public Builder resultId(String var1);

        public Builder profileId(String var1);

        public Builder score(Double var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder rulesetName(String var1);

        public Builder evaluationContext(String var1);

        public Builder startedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder jobName(String var1);

        public Builder jobRunId(String var1);

        public Builder rulesetEvaluationRunId(String var1);

        public Builder ruleResults(Collection<DataQualityRuleResult> var1);

        public Builder ruleResults(DataQualityRuleResult ... var1);

        public Builder ruleResults(Consumer<DataQualityRuleResult.Builder> ... var1);

        public Builder analyzerResults(Collection<DataQualityAnalyzerResult> var1);

        public Builder analyzerResults(DataQualityAnalyzerResult ... var1);

        public Builder analyzerResults(Consumer<DataQualityAnalyzerResult.Builder> ... var1);

        public Builder observations(Collection<DataQualityObservation> var1);

        public Builder observations(DataQualityObservation ... var1);

        public Builder observations(Consumer<DataQualityObservation.Builder> ... var1);

        public Builder aggregatedMetrics(DataQualityAggregatedMetrics var1);

        default public Builder aggregatedMetrics(Consumer<DataQualityAggregatedMetrics.Builder> aggregatedMetrics) {
            return this.aggregatedMetrics((DataQualityAggregatedMetrics)((DataQualityAggregatedMetrics.Builder)DataQualityAggregatedMetrics.builder().applyMutation(aggregatedMetrics)).build());
        }
    }
}

