/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CrawlerHistoryState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrawlerHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrawlerHistory> {
    private static final SdkField<String> CRAWL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlId").getter(CrawlerHistory.getter(CrawlerHistory::crawlId)).setter(CrawlerHistory.setter(Builder::crawlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CrawlerHistory.getter(CrawlerHistory::stateAsString)).setter(CrawlerHistory.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CrawlerHistory.getter(CrawlerHistory::startTime)).setter(CrawlerHistory.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CrawlerHistory.getter(CrawlerHistory::endTime)).setter(CrawlerHistory.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Summary").getter(CrawlerHistory.getter(CrawlerHistory::summary)).setter(CrawlerHistory.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(CrawlerHistory.getter(CrawlerHistory::errorMessage)).setter(CrawlerHistory.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroup").getter(CrawlerHistory.getter(CrawlerHistory::logGroup)).setter(CrawlerHistory.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()}).build();
    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogStream").getter(CrawlerHistory.getter(CrawlerHistory::logStream)).setter(CrawlerHistory.setter(Builder::logStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()}).build();
    private static final SdkField<String> MESSAGE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessagePrefix").getter(CrawlerHistory.getter(CrawlerHistory::messagePrefix)).setter(CrawlerHistory.setter(Builder::messagePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagePrefix").build()}).build();
    private static final SdkField<Double> DPU_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DPUHour").getter(CrawlerHistory.getter(CrawlerHistory::dpuHour)).setter(CrawlerHistory.setter(Builder::dpuHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_ID_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD, SUMMARY_FIELD, ERROR_MESSAGE_FIELD, LOG_GROUP_FIELD, LOG_STREAM_FIELD, MESSAGE_PREFIX_FIELD, DPU_HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CrawlerHistory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String crawlId;
    private final String state;
    private final Instant startTime;
    private final Instant endTime;
    private final String summary;
    private final String errorMessage;
    private final String logGroup;
    private final String logStream;
    private final String messagePrefix;
    private final Double dpuHour;

    private CrawlerHistory(BuilderImpl builder) {
        this.crawlId = builder.crawlId;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summary = builder.summary;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
        this.messagePrefix = builder.messagePrefix;
        this.dpuHour = builder.dpuHour;
    }

    public final String crawlId() {
        return this.crawlId;
    }

    public final CrawlerHistoryState state() {
        return CrawlerHistoryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String summary() {
        return this.summary;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String logGroup() {
        return this.logGroup;
    }

    public final String logStream() {
        return this.logStream;
    }

    public final String messagePrefix() {
        return this.messagePrefix;
    }

    public final Double dpuHour() {
        return this.dpuHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.messagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpuHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerHistory)) {
            return false;
        }
        CrawlerHistory other = (CrawlerHistory)obj;
        return Objects.equals(this.crawlId(), other.crawlId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.logGroup(), other.logGroup()) && Objects.equals(this.logStream(), other.logStream()) && Objects.equals(this.messagePrefix(), other.messagePrefix()) && Objects.equals(this.dpuHour(), other.dpuHour());
    }

    public final String toString() {
        return ToString.builder((String)"CrawlerHistory").add("CrawlId", (Object)this.crawlId()).add("State", (Object)this.stateAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Summary", (Object)this.summary()).add("ErrorMessage", (Object)this.errorMessage()).add("LogGroup", (Object)this.logGroup()).add("LogStream", (Object)this.logStream()).add("MessagePrefix", (Object)this.messagePrefix()).add("DPUHour", (Object)this.dpuHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlId": {
                return Optional.ofNullable(clazz.cast(this.crawlId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
            case "LogStream": {
                return Optional.ofNullable(clazz.cast(this.logStream()));
            }
            case "MessagePrefix": {
                return Optional.ofNullable(clazz.cast(this.messagePrefix()));
            }
            case "DPUHour": {
                return Optional.ofNullable(clazz.cast(this.dpuHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CrawlId", CRAWL_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("LogGroup", LOG_GROUP_FIELD);
        map.put("LogStream", LOG_STREAM_FIELD);
        map.put("MessagePrefix", MESSAGE_PREFIX_FIELD);
        map.put("DPUHour", DPU_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrawlerHistory, T> g) {
        return obj -> g.apply((CrawlerHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String crawlId;
        private String state;
        private Instant startTime;
        private Instant endTime;
        private String summary;
        private String errorMessage;
        private String logGroup;
        private String logStream;
        private String messagePrefix;
        private Double dpuHour;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerHistory model) {
            this.crawlId(model.crawlId);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.summary(model.summary);
            this.errorMessage(model.errorMessage);
            this.logGroup(model.logGroup);
            this.logStream(model.logStream);
            this.messagePrefix(model.messagePrefix);
            this.dpuHour(model.dpuHour);
        }

        public final String getCrawlId() {
            return this.crawlId;
        }

        public final void setCrawlId(String crawlId) {
            this.crawlId = crawlId;
        }

        @Override
        public final Builder crawlId(String crawlId) {
            this.crawlId = crawlId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CrawlerHistoryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final String getMessagePrefix() {
            return this.messagePrefix;
        }

        public final void setMessagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
        }

        @Override
        public final Builder messagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public final Double getDpuHour() {
            return this.dpuHour;
        }

        public final void setDpuHour(Double dpuHour) {
            this.dpuHour = dpuHour;
        }

        @Override
        public final Builder dpuHour(Double dpuHour) {
            this.dpuHour = dpuHour;
            return this;
        }

        public CrawlerHistory build() {
            return new CrawlerHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrawlerHistory> {
        public Builder crawlId(String var1);

        public Builder state(String var1);

        public Builder state(CrawlerHistoryState var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder summary(String var1);

        public Builder errorMessage(String var1);

        public Builder logGroup(String var1);

        public Builder logStream(String var1);

        public Builder messagePrefix(String var1);

        public Builder dpuHour(Double var1);
    }
}

