/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.UnfilteredPartition;
import software.amazon.awssdk.services.glue.model.UnfilteredPartitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUnfilteredPartitionsMetadataResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetUnfilteredPartitionsMetadataResponse> {
    private static final SdkField<List<UnfilteredPartition>> UNFILTERED_PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnfilteredPartitions").getter(GetUnfilteredPartitionsMetadataResponse.getter(GetUnfilteredPartitionsMetadataResponse::unfilteredPartitions)).setter(GetUnfilteredPartitionsMetadataResponse.setter(Builder::unfilteredPartitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnfilteredPartitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnfilteredPartition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetUnfilteredPartitionsMetadataResponse.getter(GetUnfilteredPartitionsMetadataResponse::nextToken)).setter(GetUnfilteredPartitionsMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNFILTERED_PARTITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUnfilteredPartitionsMetadataResponse.memberNameToFieldInitializer();
    private final List<UnfilteredPartition> unfilteredPartitions;
    private final String nextToken;

    private GetUnfilteredPartitionsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.unfilteredPartitions = builder.unfilteredPartitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUnfilteredPartitions() {
        return this.unfilteredPartitions != null && !(this.unfilteredPartitions instanceof SdkAutoConstructList);
    }

    public final List<UnfilteredPartition> unfilteredPartitions() {
        return this.unfilteredPartitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnfilteredPartitions() ? this.unfilteredPartitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredPartitionsMetadataResponse)) {
            return false;
        }
        GetUnfilteredPartitionsMetadataResponse other = (GetUnfilteredPartitionsMetadataResponse)((Object)obj);
        return this.hasUnfilteredPartitions() == other.hasUnfilteredPartitions() && Objects.equals(this.unfilteredPartitions(), other.unfilteredPartitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetUnfilteredPartitionsMetadataResponse").add("UnfilteredPartitions", this.hasUnfilteredPartitions() ? this.unfilteredPartitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnfilteredPartitions": {
                return Optional.ofNullable(clazz.cast(this.unfilteredPartitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UnfilteredPartitions", UNFILTERED_PARTITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredPartitionsMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredPartitionsMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<UnfilteredPartition> unfilteredPartitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredPartitionsMetadataResponse model) {
            super(model);
            this.unfilteredPartitions(model.unfilteredPartitions);
            this.nextToken(model.nextToken);
        }

        public final List<UnfilteredPartition.Builder> getUnfilteredPartitions() {
            List<UnfilteredPartition.Builder> result = UnfilteredPartitionListCopier.copyToBuilder(this.unfilteredPartitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnfilteredPartitions(Collection<UnfilteredPartition.BuilderImpl> unfilteredPartitions) {
            this.unfilteredPartitions = UnfilteredPartitionListCopier.copyFromBuilder(unfilteredPartitions);
        }

        @Override
        public final Builder unfilteredPartitions(Collection<UnfilteredPartition> unfilteredPartitions) {
            this.unfilteredPartitions = UnfilteredPartitionListCopier.copy(unfilteredPartitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unfilteredPartitions(UnfilteredPartition ... unfilteredPartitions) {
            this.unfilteredPartitions(Arrays.asList(unfilteredPartitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unfilteredPartitions(Consumer<UnfilteredPartition.Builder> ... unfilteredPartitions) {
            this.unfilteredPartitions(Stream.of(unfilteredPartitions).map(c -> (UnfilteredPartition)((UnfilteredPartition.Builder)UnfilteredPartition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetUnfilteredPartitionsMetadataResponse build() {
            return new GetUnfilteredPartitionsMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUnfilteredPartitionsMetadataResponse> {
        public Builder unfilteredPartitions(Collection<UnfilteredPartition> var1);

        public Builder unfilteredPartitions(UnfilteredPartition ... var1);

        public Builder unfilteredPartitions(Consumer<UnfilteredPartition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

