/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.IcebergStructField;
import software.amazon.awssdk.services.glue.model.IcebergStructFieldListCopier;
import software.amazon.awssdk.services.glue.model.IcebergStructTypeEnum;
import software.amazon.awssdk.services.glue.model.IntegerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergSchema> {
    private static final SdkField<Integer> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SchemaId").getter(IcebergSchema.getter(IcebergSchema::schemaId)).setter(IcebergSchema.setter(Builder::schemaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<List<Integer>> IDENTIFIER_FIELD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentifierFieldIds").getter(IcebergSchema.getter(IcebergSchema::identifierFieldIds)).setter(IcebergSchema.setter(Builder::identifierFieldIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifierFieldIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(IcebergSchema.getter(IcebergSchema::typeAsString)).setter(IcebergSchema.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<IcebergStructField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(IcebergSchema.getter(IcebergSchema::fields)).setter(IcebergSchema.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IcebergStructField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, IDENTIFIER_FIELD_IDS_FIELD, TYPE_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer schemaId;
    private final List<Integer> identifierFieldIds;
    private final String type;
    private final List<IcebergStructField> fields;

    private IcebergSchema(BuilderImpl builder) {
        this.schemaId = builder.schemaId;
        this.identifierFieldIds = builder.identifierFieldIds;
        this.type = builder.type;
        this.fields = builder.fields;
    }

    public final Integer schemaId() {
        return this.schemaId;
    }

    public final boolean hasIdentifierFieldIds() {
        return this.identifierFieldIds != null && !(this.identifierFieldIds instanceof SdkAutoConstructList);
    }

    public final List<Integer> identifierFieldIds() {
        return this.identifierFieldIds;
    }

    public final IcebergStructTypeEnum type() {
        return IcebergStructTypeEnum.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<IcebergStructField> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifierFieldIds() ? this.identifierFieldIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSchema)) {
            return false;
        }
        IcebergSchema other = (IcebergSchema)obj;
        return Objects.equals(this.schemaId(), other.schemaId()) && this.hasIdentifierFieldIds() == other.hasIdentifierFieldIds() && Objects.equals(this.identifierFieldIds(), other.identifierFieldIds()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergSchema").add("SchemaId", (Object)this.schemaId()).add("IdentifierFieldIds", this.hasIdentifierFieldIds() ? this.identifierFieldIds() : null).add("Type", (Object)this.typeAsString()).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "IdentifierFieldIds": {
                return Optional.ofNullable(clazz.cast(this.identifierFieldIds()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("IdentifierFieldIds", IDENTIFIER_FIELD_IDS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergSchema, T> g) {
        return obj -> g.apply((IcebergSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer schemaId;
        private List<Integer> identifierFieldIds = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private List<IcebergStructField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSchema model) {
            this.schemaId(model.schemaId);
            this.identifierFieldIds(model.identifierFieldIds);
            this.type(model.type);
            this.fields(model.fields);
        }

        public final Integer getSchemaId() {
            return this.schemaId;
        }

        public final void setSchemaId(Integer schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(Integer schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final Collection<Integer> getIdentifierFieldIds() {
            if (this.identifierFieldIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identifierFieldIds;
        }

        public final void setIdentifierFieldIds(Collection<Integer> identifierFieldIds) {
            this.identifierFieldIds = IntegerListCopier.copy(identifierFieldIds);
        }

        @Override
        public final Builder identifierFieldIds(Collection<Integer> identifierFieldIds) {
            this.identifierFieldIds = IntegerListCopier.copy(identifierFieldIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifierFieldIds(Integer ... identifierFieldIds) {
            this.identifierFieldIds(Arrays.asList(identifierFieldIds));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IcebergStructTypeEnum type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<IcebergStructField.Builder> getFields() {
            List<IcebergStructField.Builder> result = IcebergStructFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<IcebergStructField.BuilderImpl> fields) {
            this.fields = IcebergStructFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<IcebergStructField> fields) {
            this.fields = IcebergStructFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(IcebergStructField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<IcebergStructField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (IcebergStructField)((IcebergStructField.Builder)IcebergStructField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IcebergSchema build() {
            return new IcebergSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergSchema> {
        public Builder schemaId(Integer var1);

        public Builder identifierFieldIds(Collection<Integer> var1);

        public Builder identifierFieldIds(Integer ... var1);

        public Builder type(String var1);

        public Builder type(IcebergStructTypeEnum var1);

        public Builder fields(Collection<IcebergStructField> var1);

        public Builder fields(IcebergStructField ... var1);

        public Builder fields(Consumer<IcebergStructField.Builder> ... var1);
    }
}

