/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.OrchestrationStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGlueIdentityCenterConfigurationResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetGlueIdentityCenterConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(GetGlueIdentityCenterConfigurationResponse.getter(GetGlueIdentityCenterConfigurationResponse::applicationArn)).setter(GetGlueIdentityCenterConfigurationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(GetGlueIdentityCenterConfigurationResponse.getter(GetGlueIdentityCenterConfigurationResponse::instanceArn)).setter(GetGlueIdentityCenterConfigurationResponse.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<List<String>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scopes").getter(GetGlueIdentityCenterConfigurationResponse.getter(GetGlueIdentityCenterConfigurationResponse::scopes)).setter(GetGlueIdentityCenterConfigurationResponse.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_BACKGROUND_SESSIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserBackgroundSessionsEnabled").getter(GetGlueIdentityCenterConfigurationResponse.getter(GetGlueIdentityCenterConfigurationResponse::userBackgroundSessionsEnabled)).setter(GetGlueIdentityCenterConfigurationResponse.setter(Builder::userBackgroundSessionsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBackgroundSessionsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, INSTANCE_ARN_FIELD, SCOPES_FIELD, USER_BACKGROUND_SESSIONS_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGlueIdentityCenterConfigurationResponse.memberNameToFieldInitializer();
    private final String applicationArn;
    private final String instanceArn;
    private final List<String> scopes;
    private final Boolean userBackgroundSessionsEnabled;

    private GetGlueIdentityCenterConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.instanceArn = builder.instanceArn;
        this.scopes = builder.scopes;
        this.userBackgroundSessionsEnabled = builder.userBackgroundSessionsEnabled;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<String> scopes() {
        return this.scopes;
    }

    public final Boolean userBackgroundSessionsEnabled() {
        return this.userBackgroundSessionsEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userBackgroundSessionsEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlueIdentityCenterConfigurationResponse)) {
            return false;
        }
        GetGlueIdentityCenterConfigurationResponse other = (GetGlueIdentityCenterConfigurationResponse)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.instanceArn(), other.instanceArn()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes()) && Objects.equals(this.userBackgroundSessionsEnabled(), other.userBackgroundSessionsEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"GetGlueIdentityCenterConfigurationResponse").add("ApplicationArn", (Object)this.applicationArn()).add("InstanceArn", (Object)this.instanceArn()).add("Scopes", this.hasScopes() ? this.scopes() : null).add("UserBackgroundSessionsEnabled", (Object)this.userBackgroundSessionsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "UserBackgroundSessionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.userBackgroundSessionsEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Scopes", SCOPES_FIELD);
        map.put("UserBackgroundSessionsEnabled", USER_BACKGROUND_SESSIONS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGlueIdentityCenterConfigurationResponse, T> g) {
        return obj -> g.apply((GetGlueIdentityCenterConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String instanceArn;
        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();
        private Boolean userBackgroundSessionsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlueIdentityCenterConfigurationResponse model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.instanceArn(model.instanceArn);
            this.scopes(model.scopes);
            this.userBackgroundSessionsEnabled(model.userBackgroundSessionsEnabled);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final Collection<String> getScopes() {
            if (this.scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = OrchestrationStringListCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = OrchestrationStringListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        public final Boolean getUserBackgroundSessionsEnabled() {
            return this.userBackgroundSessionsEnabled;
        }

        public final void setUserBackgroundSessionsEnabled(Boolean userBackgroundSessionsEnabled) {
            this.userBackgroundSessionsEnabled = userBackgroundSessionsEnabled;
        }

        @Override
        public final Builder userBackgroundSessionsEnabled(Boolean userBackgroundSessionsEnabled) {
            this.userBackgroundSessionsEnabled = userBackgroundSessionsEnabled;
            return this;
        }

        @Override
        public GetGlueIdentityCenterConfigurationResponse build() {
            return new GetGlueIdentityCenterConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGlueIdentityCenterConfigurationResponse> {
        public Builder applicationArn(String var1);

        public Builder instanceArn(String var1);

        public Builder scopes(Collection<String> var1);

        public Builder scopes(String ... var1);

        public Builder userBackgroundSessionsEnabled(Boolean var1);
    }
}

