/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BoundedPartitionValueListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePartitionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdatePartitionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(UpdatePartitionRequest.getter(UpdatePartitionRequest::catalogId)).setter(UpdatePartitionRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(UpdatePartitionRequest.getter(UpdatePartitionRequest::databaseName)).setter(UpdatePartitionRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdatePartitionRequest.getter(UpdatePartitionRequest::tableName)).setter(UpdatePartitionRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<String>> PARTITION_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValueList").getter(UpdatePartitionRequest.getter(UpdatePartitionRequest::partitionValueList)).setter(UpdatePartitionRequest.setter(Builder::partitionValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PartitionInput> PARTITION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartitionInput").getter(UpdatePartitionRequest.getter(UpdatePartitionRequest::partitionInput)).setter(UpdatePartitionRequest.setter(Builder::partitionInput)).constructor(PartitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, PARTITION_VALUE_LIST_FIELD, PARTITION_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePartitionRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final List<String> partitionValueList;
    private final PartitionInput partitionInput;

    private UpdatePartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionValueList = builder.partitionValueList;
        this.partitionInput = builder.partitionInput;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasPartitionValueList() {
        return this.partitionValueList != null && !(this.partitionValueList instanceof SdkAutoConstructList);
    }

    public final List<String> partitionValueList() {
        return this.partitionValueList;
    }

    public final PartitionInput partitionInput() {
        return this.partitionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValueList() ? this.partitionValueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartitionRequest)) {
            return false;
        }
        UpdatePartitionRequest other = (UpdatePartitionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasPartitionValueList() == other.hasPartitionValueList() && Objects.equals(this.partitionValueList(), other.partitionValueList()) && Objects.equals(this.partitionInput(), other.partitionInput());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePartitionRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("PartitionValueList", this.hasPartitionValueList() ? this.partitionValueList() : null).add("PartitionInput", (Object)this.partitionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "PartitionValueList": {
                return Optional.ofNullable(clazz.cast(this.partitionValueList()));
            }
            case "PartitionInput": {
                return Optional.ofNullable(clazz.cast(this.partitionInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("PartitionValueList", PARTITION_VALUE_LIST_FIELD);
        map.put("PartitionInput", PARTITION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartitionRequest, T> g) {
        return obj -> g.apply((UpdatePartitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<String> partitionValueList = DefaultSdkAutoConstructList.getInstance();
        private PartitionInput partitionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartitionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.partitionValueList(model.partitionValueList);
            this.partitionInput(model.partitionInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Collection<String> getPartitionValueList() {
            if (this.partitionValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValueList;
        }

        public final void setPartitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
        }

        @Override
        public final Builder partitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValueList(String ... partitionValueList) {
            this.partitionValueList(Arrays.asList(partitionValueList));
            return this;
        }

        public final PartitionInput.Builder getPartitionInput() {
            return this.partitionInput != null ? this.partitionInput.toBuilder() : null;
        }

        public final void setPartitionInput(PartitionInput.BuilderImpl partitionInput) {
            this.partitionInput = partitionInput != null ? partitionInput.build() : null;
        }

        @Override
        public final Builder partitionInput(PartitionInput partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePartitionRequest build() {
            return new UpdatePartitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePartitionRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder partitionValueList(Collection<String> var1);

        public Builder partitionValueList(String ... var1);

        public Builder partitionInput(PartitionInput var1);

        default public Builder partitionInput(Consumer<PartitionInput.Builder> partitionInput) {
            return this.partitionInput((PartitionInput)((PartitionInput.Builder)PartitionInput.builder().applyMutation(partitionInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

