/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.IcebergPartitionField;
import software.amazon.awssdk.services.glue.model.IcebergPartitionSpecFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergPartitionSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergPartitionSpec> {
    private static final SdkField<List<IcebergPartitionField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(IcebergPartitionSpec.getter(IcebergPartitionSpec::fields)).setter(IcebergPartitionSpec.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IcebergPartitionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SPEC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SpecId").getter(IcebergPartitionSpec.getter(IcebergPartitionSpec::specId)).setter(IcebergPartitionSpec.setter(Builder::specId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, SPEC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergPartitionSpec.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<IcebergPartitionField> fields;
    private final Integer specId;

    private IcebergPartitionSpec(BuilderImpl builder) {
        this.fields = builder.fields;
        this.specId = builder.specId;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<IcebergPartitionField> fields() {
        return this.fields;
    }

    public final Integer specId() {
        return this.specId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.specId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergPartitionSpec)) {
            return false;
        }
        IcebergPartitionSpec other = (IcebergPartitionSpec)obj;
        return this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.specId(), other.specId());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergPartitionSpec").add("Fields", this.hasFields() ? this.fields() : null).add("SpecId", (Object)this.specId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "SpecId": {
                return Optional.ofNullable(clazz.cast(this.specId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Fields", FIELDS_FIELD);
        map.put("SpecId", SPEC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergPartitionSpec, T> g) {
        return obj -> g.apply((IcebergPartitionSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IcebergPartitionField> fields = DefaultSdkAutoConstructList.getInstance();
        private Integer specId;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergPartitionSpec model) {
            this.fields(model.fields);
            this.specId(model.specId);
        }

        public final List<IcebergPartitionField.Builder> getFields() {
            List<IcebergPartitionField.Builder> result = IcebergPartitionSpecFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<IcebergPartitionField.BuilderImpl> fields) {
            this.fields = IcebergPartitionSpecFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<IcebergPartitionField> fields) {
            this.fields = IcebergPartitionSpecFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(IcebergPartitionField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<IcebergPartitionField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (IcebergPartitionField)((IcebergPartitionField.Builder)IcebergPartitionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSpecId() {
            return this.specId;
        }

        public final void setSpecId(Integer specId) {
            this.specId = specId;
        }

        @Override
        public final Builder specId(Integer specId) {
            this.specId = specId;
            return this;
        }

        public IcebergPartitionSpec build() {
            return new IcebergPartitionSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergPartitionSpec> {
        public Builder fields(Collection<IcebergPartitionField> var1);

        public Builder fields(IcebergPartitionField ... var1);

        public Builder fields(Consumer<IcebergPartitionField.Builder> ... var1);

        public Builder specId(Integer var1);
    }
}

