/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.IntegrationSourcePropertiesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegrationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegrationConfig> {
    private static final SdkField<String> REFRESH_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshInterval").getter(IntegrationConfig.getter(IntegrationConfig::refreshInterval)).setter(IntegrationConfig.setter(Builder::refreshInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshInterval").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SourceProperties").getter(IntegrationConfig.getter(IntegrationConfig::sourceProperties)).setter(IntegrationConfig.setter(Builder::sourceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CONTINUOUS_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ContinuousSync").getter(IntegrationConfig.getter(IntegrationConfig::continuousSync)).setter(IntegrationConfig.setter(Builder::continuousSync)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousSync").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_INTERVAL_FIELD, SOURCE_PROPERTIES_FIELD, CONTINUOUS_SYNC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegrationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String refreshInterval;
    private final Map<String, String> sourceProperties;
    private final Boolean continuousSync;

    private IntegrationConfig(BuilderImpl builder) {
        this.refreshInterval = builder.refreshInterval;
        this.sourceProperties = builder.sourceProperties;
        this.continuousSync = builder.continuousSync;
    }

    public final String refreshInterval() {
        return this.refreshInterval;
    }

    public final boolean hasSourceProperties() {
        return this.sourceProperties != null && !(this.sourceProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceProperties() {
        return this.sourceProperties;
    }

    public final Boolean continuousSync() {
        return this.continuousSync;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceProperties() ? this.sourceProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousSync());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationConfig)) {
            return false;
        }
        IntegrationConfig other = (IntegrationConfig)obj;
        return Objects.equals(this.refreshInterval(), other.refreshInterval()) && this.hasSourceProperties() == other.hasSourceProperties() && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.continuousSync(), other.continuousSync());
    }

    public final String toString() {
        return ToString.builder((String)"IntegrationConfig").add("RefreshInterval", (Object)this.refreshInterval()).add("SourceProperties", this.hasSourceProperties() ? this.sourceProperties() : null).add("ContinuousSync", (Object)this.continuousSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RefreshInterval": {
                return Optional.ofNullable(clazz.cast(this.refreshInterval()));
            }
            case "SourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "ContinuousSync": {
                return Optional.ofNullable(clazz.cast(this.continuousSync()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RefreshInterval", REFRESH_INTERVAL_FIELD);
        map.put("SourceProperties", SOURCE_PROPERTIES_FIELD);
        map.put("ContinuousSync", CONTINUOUS_SYNC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationConfig, T> g) {
        return obj -> g.apply((IntegrationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String refreshInterval;
        private Map<String, String> sourceProperties = DefaultSdkAutoConstructMap.getInstance();
        private Boolean continuousSync;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationConfig model) {
            this.refreshInterval(model.refreshInterval);
            this.sourceProperties(model.sourceProperties);
            this.continuousSync(model.continuousSync);
        }

        public final String getRefreshInterval() {
            return this.refreshInterval;
        }

        public final void setRefreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        @Override
        public final Builder refreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public final Map<String, String> getSourceProperties() {
            if (this.sourceProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceProperties;
        }

        public final void setSourceProperties(Map<String, String> sourceProperties) {
            this.sourceProperties = IntegrationSourcePropertiesMapCopier.copy(sourceProperties);
        }

        @Override
        public final Builder sourceProperties(Map<String, String> sourceProperties) {
            this.sourceProperties = IntegrationSourcePropertiesMapCopier.copy(sourceProperties);
            return this;
        }

        public final Boolean getContinuousSync() {
            return this.continuousSync;
        }

        public final void setContinuousSync(Boolean continuousSync) {
            this.continuousSync = continuousSync;
        }

        @Override
        public final Builder continuousSync(Boolean continuousSync) {
            this.continuousSync = continuousSync;
            return this;
        }

        public IntegrationConfig build() {
            return new IntegrationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegrationConfig> {
        public Builder refreshInterval(String var1);

        public Builder sourceProperties(Map<String, String> var1);

        public Builder continuousSync(Boolean var1);
    }
}

