/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TaskRun;
import software.amazon.awssdk.services.glue.model.TaskRunListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlTaskRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetMlTaskRunsResponse> {
    private static final SdkField<List<TaskRun>> TASK_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskRuns").getter(GetMlTaskRunsResponse.getter(GetMlTaskRunsResponse::taskRuns)).setter(GetMlTaskRunsResponse.setter(Builder::taskRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMlTaskRunsResponse.getter(GetMlTaskRunsResponse::nextToken)).setter(GetMlTaskRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMlTaskRunsResponse.memberNameToFieldInitializer();
    private final List<TaskRun> taskRuns;
    private final String nextToken;

    private GetMlTaskRunsResponse(BuilderImpl builder) {
        super(builder);
        this.taskRuns = builder.taskRuns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTaskRuns() {
        return this.taskRuns != null && !(this.taskRuns instanceof SdkAutoConstructList);
    }

    public final List<TaskRun> taskRuns() {
        return this.taskRuns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskRuns() ? this.taskRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTaskRunsResponse)) {
            return false;
        }
        GetMlTaskRunsResponse other = (GetMlTaskRunsResponse)((Object)obj);
        return this.hasTaskRuns() == other.hasTaskRuns() && Objects.equals(this.taskRuns(), other.taskRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlTaskRunsResponse").add("TaskRuns", this.hasTaskRuns() ? this.taskRuns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskRuns": {
                return Optional.ofNullable(clazz.cast(this.taskRuns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskRuns", TASK_RUNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlTaskRunsResponse, T> g) {
        return obj -> g.apply((GetMlTaskRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<TaskRun> taskRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTaskRunsResponse model) {
            super(model);
            this.taskRuns(model.taskRuns);
            this.nextToken(model.nextToken);
        }

        public final List<TaskRun.Builder> getTaskRuns() {
            List<TaskRun.Builder> result = TaskRunListCopier.copyToBuilder(this.taskRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskRuns(Collection<TaskRun.BuilderImpl> taskRuns) {
            this.taskRuns = TaskRunListCopier.copyFromBuilder(taskRuns);
        }

        @Override
        public final Builder taskRuns(Collection<TaskRun> taskRuns) {
            this.taskRuns = TaskRunListCopier.copy(taskRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskRuns(TaskRun ... taskRuns) {
            this.taskRuns(Arrays.asList(taskRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskRuns(Consumer<TaskRun.Builder> ... taskRuns) {
            this.taskRuns(Stream.of(taskRuns).map(c -> (TaskRun)((TaskRun.Builder)TaskRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetMlTaskRunsResponse build() {
            return new GetMlTaskRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlTaskRunsResponse> {
        public Builder taskRuns(Collection<TaskRun> var1);

        public Builder taskRuns(TaskRun ... var1);

        public Builder taskRuns(Consumer<TaskRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

