/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DataQualityTargetTable;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataQualityRulesetRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateDataQualityRulesetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::name)).setter(CreateDataQualityRulesetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::description)).setter(CreateDataQualityRulesetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RULESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ruleset").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::ruleset)).setter(CreateDataQualityRulesetRequest.setter(Builder::ruleset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::tags)).setter(CreateDataQualityRulesetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DataQualityTargetTable> TARGET_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTable").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::targetTable)).setter(CreateDataQualityRulesetRequest.setter(Builder::targetTable)).constructor(DataQualityTargetTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()}).build();
    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataQualitySecurityConfiguration").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::dataQualitySecurityConfiguration)).setter(CreateDataQualityRulesetRequest.setter(Builder::dataQualitySecurityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateDataQualityRulesetRequest.getter(CreateDataQualityRulesetRequest::clientToken)).setter(CreateDataQualityRulesetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RULESET_FIELD, TAGS_FIELD, TARGET_TABLE_FIELD, DATA_QUALITY_SECURITY_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataQualityRulesetRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String ruleset;
    private final Map<String, String> tags;
    private final DataQualityTargetTable targetTable;
    private final String dataQualitySecurityConfiguration;
    private final String clientToken;

    private CreateDataQualityRulesetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.ruleset = builder.ruleset;
        this.tags = builder.tags;
        this.targetTable = builder.targetTable;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String ruleset() {
        return this.ruleset;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DataQualityTargetTable targetTable() {
        return this.targetTable;
    }

    public final String dataQualitySecurityConfiguration() {
        return this.dataQualitySecurityConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualitySecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataQualityRulesetRequest)) {
            return false;
        }
        CreateDataQualityRulesetRequest other = (CreateDataQualityRulesetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleset(), other.ruleset()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetTable(), other.targetTable()) && Objects.equals(this.dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataQualityRulesetRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Ruleset", (Object)this.ruleset()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetTable", (Object)this.targetTable()).add("DataQualitySecurityConfiguration", (Object)this.dataQualitySecurityConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Ruleset": {
                return Optional.ofNullable(clazz.cast(this.ruleset()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TargetTable": {
                return Optional.ofNullable(clazz.cast(this.targetTable()));
            }
            case "DataQualitySecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataQualitySecurityConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Ruleset", RULESET_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TargetTable", TARGET_TABLE_FIELD);
        map.put("DataQualitySecurityConfiguration", DATA_QUALITY_SECURITY_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataQualityRulesetRequest, T> g) {
        return obj -> g.apply((CreateDataQualityRulesetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String ruleset;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private DataQualityTargetTable targetTable;
        private String dataQualitySecurityConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataQualityRulesetRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.ruleset(model.ruleset);
            this.tags(model.tags);
            this.targetTable(model.targetTable);
            this.dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleset() {
            return this.ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final DataQualityTargetTable.Builder getTargetTable() {
            return this.targetTable != null ? this.targetTable.toBuilder() : null;
        }

        public final void setTargetTable(DataQualityTargetTable.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        @Override
        public final Builder targetTable(DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return this.dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataQualityRulesetRequest build() {
            return new CreateDataQualityRulesetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataQualityRulesetRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder ruleset(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetTable(DataQualityTargetTable var1);

        default public Builder targetTable(Consumer<DataQualityTargetTable.Builder> targetTable) {
            return this.targetTable((DataQualityTargetTable)((DataQualityTargetTable.Builder)DataQualityTargetTable.builder().applyMutation(targetTable)).build());
        }

        public Builder dataQualitySecurityConfiguration(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

