/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.InclusionAnnotationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatisticModelResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatisticModelResult> {
    private static final SdkField<Double> LOWER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LowerBound").getter(StatisticModelResult.getter(StatisticModelResult::lowerBound)).setter(StatisticModelResult.setter(Builder::lowerBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBound").build()}).build();
    private static final SdkField<Double> UPPER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UpperBound").getter(StatisticModelResult.getter(StatisticModelResult::upperBound)).setter(StatisticModelResult.setter(Builder::upperBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBound").build()}).build();
    private static final SdkField<Double> PREDICTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PredictedValue").getter(StatisticModelResult.getter(StatisticModelResult::predictedValue)).setter(StatisticModelResult.setter(Builder::predictedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictedValue").build()}).build();
    private static final SdkField<Double> ACTUAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ActualValue").getter(StatisticModelResult.getter(StatisticModelResult::actualValue)).setter(StatisticModelResult.setter(Builder::actualValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Date").getter(StatisticModelResult.getter(StatisticModelResult::date)).setter(StatisticModelResult.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<String> INCLUSION_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InclusionAnnotation").getter(StatisticModelResult.getter(StatisticModelResult::inclusionAnnotationAsString)).setter(StatisticModelResult.setter(Builder::inclusionAnnotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOWER_BOUND_FIELD, UPPER_BOUND_FIELD, PREDICTED_VALUE_FIELD, ACTUAL_VALUE_FIELD, DATE_FIELD, INCLUSION_ANNOTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StatisticModelResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double lowerBound;
    private final Double upperBound;
    private final Double predictedValue;
    private final Double actualValue;
    private final Instant date;
    private final String inclusionAnnotation;

    private StatisticModelResult(BuilderImpl builder) {
        this.lowerBound = builder.lowerBound;
        this.upperBound = builder.upperBound;
        this.predictedValue = builder.predictedValue;
        this.actualValue = builder.actualValue;
        this.date = builder.date;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    public final Double lowerBound() {
        return this.lowerBound;
    }

    public final Double upperBound() {
        return this.upperBound;
    }

    public final Double predictedValue() {
        return this.predictedValue;
    }

    public final Double actualValue() {
        return this.actualValue;
    }

    public final Instant date() {
        return this.date;
    }

    public final InclusionAnnotationValue inclusionAnnotation() {
        return InclusionAnnotationValue.fromValue(this.inclusionAnnotation);
    }

    public final String inclusionAnnotationAsString() {
        return this.inclusionAnnotation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionAnnotationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticModelResult)) {
            return false;
        }
        StatisticModelResult other = (StatisticModelResult)obj;
        return Objects.equals(this.lowerBound(), other.lowerBound()) && Objects.equals(this.upperBound(), other.upperBound()) && Objects.equals(this.predictedValue(), other.predictedValue()) && Objects.equals(this.actualValue(), other.actualValue()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.inclusionAnnotationAsString(), other.inclusionAnnotationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StatisticModelResult").add("LowerBound", (Object)this.lowerBound()).add("UpperBound", (Object)this.upperBound()).add("PredictedValue", (Object)this.predictedValue()).add("ActualValue", (Object)this.actualValue()).add("Date", (Object)this.date()).add("InclusionAnnotation", (Object)this.inclusionAnnotationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LowerBound": {
                return Optional.ofNullable(clazz.cast(this.lowerBound()));
            }
            case "UpperBound": {
                return Optional.ofNullable(clazz.cast(this.upperBound()));
            }
            case "PredictedValue": {
                return Optional.ofNullable(clazz.cast(this.predictedValue()));
            }
            case "ActualValue": {
                return Optional.ofNullable(clazz.cast(this.actualValue()));
            }
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "InclusionAnnotation": {
                return Optional.ofNullable(clazz.cast(this.inclusionAnnotationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LowerBound", LOWER_BOUND_FIELD);
        map.put("UpperBound", UPPER_BOUND_FIELD);
        map.put("PredictedValue", PREDICTED_VALUE_FIELD);
        map.put("ActualValue", ACTUAL_VALUE_FIELD);
        map.put("Date", DATE_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatisticModelResult, T> g) {
        return obj -> g.apply((StatisticModelResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double lowerBound;
        private Double upperBound;
        private Double predictedValue;
        private Double actualValue;
        private Instant date;
        private String inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticModelResult model) {
            this.lowerBound(model.lowerBound);
            this.upperBound(model.upperBound);
            this.predictedValue(model.predictedValue);
            this.actualValue(model.actualValue);
            this.date(model.date);
            this.inclusionAnnotation(model.inclusionAnnotation);
        }

        public final Double getLowerBound() {
            return this.lowerBound;
        }

        public final void setLowerBound(Double lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Override
        public final Builder lowerBound(Double lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public final Double getUpperBound() {
            return this.upperBound;
        }

        public final void setUpperBound(Double upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Double upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public final Double getPredictedValue() {
            return this.predictedValue;
        }

        public final void setPredictedValue(Double predictedValue) {
            this.predictedValue = predictedValue;
        }

        @Override
        public final Builder predictedValue(Double predictedValue) {
            this.predictedValue = predictedValue;
            return this;
        }

        public final Double getActualValue() {
            return this.actualValue;
        }

        public final void setActualValue(Double actualValue) {
            this.actualValue = actualValue;
        }

        @Override
        public final Builder actualValue(Double actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getInclusionAnnotation() {
            return this.inclusionAnnotation;
        }

        public final void setInclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
        }

        @Override
        public final Builder inclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public final Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation) {
            this.inclusionAnnotation(inclusionAnnotation == null ? null : inclusionAnnotation.toString());
            return this;
        }

        public StatisticModelResult build() {
            return new StatisticModelResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatisticModelResult> {
        public Builder lowerBound(Double var1);

        public Builder upperBound(Double var1);

        public Builder predictedValue(Double var1);

        public Builder actualValue(Double var1);

        public Builder date(Instant var1);

        public Builder inclusionAnnotation(String var1);

        public Builder inclusionAnnotation(InclusionAnnotationValue var1);
    }
}

