/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.IntegrationAdditionalEncryptionContextMapCopier;
import software.amazon.awssdk.services.glue.model.IntegrationConfig;
import software.amazon.awssdk.services.glue.model.IntegrationTagsListCopier;
import software.amazon.awssdk.services.glue.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationName").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationName)).setter(CreateIntegrationRequest.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::sourceArn)).setter(CreateIntegrationRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::targetArn)).setter(CreateIntegrationRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::description)).setter(CreateIntegrationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DATA_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFilter").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::dataFilter)).setter(CreateIntegrationRequest.setter(Builder::dataFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFilter").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::kmsKeyId)).setter(CreateIntegrationRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalEncryptionContext").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::additionalEncryptionContext)).setter(CreateIntegrationRequest.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::tags)).setter(CreateIntegrationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IntegrationConfig> INTEGRATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IntegrationConfig").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationConfig)).setter(CreateIntegrationRequest.setter(Builder::integrationConfig)).constructor(IntegrationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD, SOURCE_ARN_FIELD, TARGET_ARN_FIELD, DESCRIPTION_FIELD, DATA_FILTER_FIELD, KMS_KEY_ID_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, TAGS_FIELD, INTEGRATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIntegrationRequest.memberNameToFieldInitializer();
    private final String integrationName;
    private final String sourceArn;
    private final String targetArn;
    private final String description;
    private final String dataFilter;
    private final String kmsKeyId;
    private final Map<String, String> additionalEncryptionContext;
    private final List<Tag> tags;
    private final IntegrationConfig integrationConfig;

    private CreateIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.sourceArn = builder.sourceArn;
        this.targetArn = builder.targetArn;
        this.description = builder.description;
        this.dataFilter = builder.dataFilter;
        this.kmsKeyId = builder.kmsKeyId;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.tags = builder.tags;
        this.integrationConfig = builder.integrationConfig;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String description() {
        return this.description;
    }

    public final String dataFilter() {
        return this.dataFilter;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final IntegrationConfig integrationConfig() {
        return this.integrationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationRequest)) {
            return false;
        }
        CreateIntegrationRequest other = (CreateIntegrationRequest)((Object)obj);
        return Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataFilter(), other.dataFilter()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.integrationConfig(), other.integrationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIntegrationRequest").add("IntegrationName", (Object)this.integrationName()).add("SourceArn", (Object)this.sourceArn()).add("TargetArn", (Object)this.targetArn()).add("Description", (Object)this.description()).add("DataFilter", (Object)this.dataFilter()).add("KmsKeyId", (Object)this.kmsKeyId()).add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("Tags", this.hasTags() ? this.tags() : null).add("IntegrationConfig", (Object)this.integrationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DataFilter": {
                return Optional.ofNullable(clazz.cast(this.dataFilter()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "AdditionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IntegrationConfig": {
                return Optional.ofNullable(clazz.cast(this.integrationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IntegrationName", INTEGRATION_NAME_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DataFilter", DATA_FILTER_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("AdditionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IntegrationConfig", INTEGRATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String integrationName;
        private String sourceArn;
        private String targetArn;
        private String description;
        private String dataFilter;
        private String kmsKeyId;
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private IntegrationConfig integrationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationRequest model) {
            super(model);
            this.integrationName(model.integrationName);
            this.sourceArn(model.sourceArn);
            this.targetArn(model.targetArn);
            this.description(model.description);
            this.dataFilter(model.dataFilter);
            this.kmsKeyId(model.kmsKeyId);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.tags(model.tags);
            this.integrationConfig(model.integrationConfig);
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataFilter() {
            return this.dataFilter;
        }

        public final void setDataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
        }

        @Override
        public final Builder dataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = IntegrationAdditionalEncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = IntegrationAdditionalEncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = IntegrationTagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = IntegrationTagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = IntegrationTagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IntegrationConfig.Builder getIntegrationConfig() {
            return this.integrationConfig != null ? this.integrationConfig.toBuilder() : null;
        }

        public final void setIntegrationConfig(IntegrationConfig.BuilderImpl integrationConfig) {
            this.integrationConfig = integrationConfig != null ? integrationConfig.build() : null;
        }

        @Override
        public final Builder integrationConfig(IntegrationConfig integrationConfig) {
            this.integrationConfig = integrationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationRequest build() {
            return new CreateIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationRequest> {
        public Builder integrationName(String var1);

        public Builder sourceArn(String var1);

        public Builder targetArn(String var1);

        public Builder description(String var1);

        public Builder dataFilter(String var1);

        public Builder kmsKeyId(String var1);

        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder integrationConfig(IntegrationConfig var1);

        default public Builder integrationConfig(Consumer<IntegrationConfig.Builder> integrationConfig) {
            return this.integrationConfig((IntegrationConfig)((IntegrationConfig.Builder)IntegrationConfig.builder().applyMutation(integrationConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

