/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableOptimizerVpcConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableOptimizerVpcConfiguration> {
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glueConnectionName").getter(TableOptimizerVpcConfiguration.getter(TableOptimizerVpcConfiguration::glueConnectionName)).setter(TableOptimizerVpcConfiguration.setter(Builder::glueConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableOptimizerVpcConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String glueConnectionName;
    private final Type type;

    private TableOptimizerVpcConfiguration(BuilderImpl builder) {
        this.glueConnectionName = builder.glueConnectionName;
        this.type = builder.type;
    }

    public final String glueConnectionName() {
        return this.glueConnectionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glueConnectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizerVpcConfiguration)) {
            return false;
        }
        TableOptimizerVpcConfiguration other = (TableOptimizerVpcConfiguration)obj;
        return Objects.equals(this.glueConnectionName(), other.glueConnectionName());
    }

    public final String toString() {
        return ToString.builder((String)"TableOptimizerVpcConfiguration").add("GlueConnectionName", (Object)this.glueConnectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "glueConnectionName": {
                return Optional.ofNullable(clazz.cast(this.glueConnectionName()));
            }
        }
        return Optional.empty();
    }

    public static TableOptimizerVpcConfiguration fromGlueConnectionName(String glueConnectionName) {
        return (TableOptimizerVpcConfiguration)TableOptimizerVpcConfiguration.builder().glueConnectionName(glueConnectionName).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("glueConnectionName", GLUE_CONNECTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizerVpcConfiguration, T> g) {
        return obj -> g.apply((TableOptimizerVpcConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GLUE_CONNECTION_NAME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String glueConnectionName;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizerVpcConfiguration model) {
            this.glueConnectionName(model.glueConnectionName);
        }

        public final String getGlueConnectionName() {
            return this.glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            String oldValue = this.glueConnectionName;
            this.glueConnectionName = glueConnectionName;
            this.handleUnionValueChange(Type.GLUE_CONNECTION_NAME, oldValue, this.glueConnectionName);
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            String oldValue = this.glueConnectionName;
            this.glueConnectionName = glueConnectionName;
            this.handleUnionValueChange(Type.GLUE_CONNECTION_NAME, oldValue, this.glueConnectionName);
            return this;
        }

        public TableOptimizerVpcConfiguration build() {
            return new TableOptimizerVpcConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableOptimizerVpcConfiguration> {
        public Builder glueConnectionName(String var1);
    }
}

