/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConfigurationMapCopier;
import software.amazon.awssdk.services.glue.model.ConfigurationObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileConfiguration> {
    private static final SdkField<Map<String, ConfigurationObject>> SESSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SessionConfiguration").getter(ProfileConfiguration.getter(ProfileConfiguration::sessionConfiguration)).setter(ProfileConfiguration.setter(Builder::sessionConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ConfigurationObject>> JOB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("JobConfiguration").getter(ProfileConfiguration.getter(ProfileConfiguration::jobConfiguration)).setter(ProfileConfiguration.setter(Builder::jobConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_CONFIGURATION_FIELD, JOB_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProfileConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ConfigurationObject> sessionConfiguration;
    private final Map<String, ConfigurationObject> jobConfiguration;

    private ProfileConfiguration(BuilderImpl builder) {
        this.sessionConfiguration = builder.sessionConfiguration;
        this.jobConfiguration = builder.jobConfiguration;
    }

    public final boolean hasSessionConfiguration() {
        return this.sessionConfiguration != null && !(this.sessionConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, ConfigurationObject> sessionConfiguration() {
        return this.sessionConfiguration;
    }

    public final boolean hasJobConfiguration() {
        return this.jobConfiguration != null && !(this.jobConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, ConfigurationObject> jobConfiguration() {
        return this.jobConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionConfiguration() ? this.sessionConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobConfiguration() ? this.jobConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)obj;
        return this.hasSessionConfiguration() == other.hasSessionConfiguration() && Objects.equals(this.sessionConfiguration(), other.sessionConfiguration()) && this.hasJobConfiguration() == other.hasJobConfiguration() && Objects.equals(this.jobConfiguration(), other.jobConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileConfiguration").add("SessionConfiguration", this.hasSessionConfiguration() ? this.sessionConfiguration() : null).add("JobConfiguration", this.hasJobConfiguration() ? this.jobConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sessionConfiguration()));
            }
            case "JobConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jobConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, ConfigurationObject>>> map = new HashMap<String, SdkField<Map<String, ConfigurationObject>>>();
        map.put("SessionConfiguration", SESSION_CONFIGURATION_FIELD);
        map.put("JobConfiguration", JOB_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileConfiguration, T> g) {
        return obj -> g.apply((ProfileConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ConfigurationObject> sessionConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ConfigurationObject> jobConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileConfiguration model) {
            this.sessionConfiguration(model.sessionConfiguration);
            this.jobConfiguration(model.jobConfiguration);
        }

        public final Map<String, ConfigurationObject.Builder> getSessionConfiguration() {
            Map<String, ConfigurationObject.Builder> result = ConfigurationMapCopier.copyToBuilder(this.sessionConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSessionConfiguration(Map<String, ConfigurationObject.BuilderImpl> sessionConfiguration) {
            this.sessionConfiguration = ConfigurationMapCopier.copyFromBuilder(sessionConfiguration);
        }

        @Override
        public final Builder sessionConfiguration(Map<String, ConfigurationObject> sessionConfiguration) {
            this.sessionConfiguration = ConfigurationMapCopier.copy(sessionConfiguration);
            return this;
        }

        public final Map<String, ConfigurationObject.Builder> getJobConfiguration() {
            Map<String, ConfigurationObject.Builder> result = ConfigurationMapCopier.copyToBuilder(this.jobConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setJobConfiguration(Map<String, ConfigurationObject.BuilderImpl> jobConfiguration) {
            this.jobConfiguration = ConfigurationMapCopier.copyFromBuilder(jobConfiguration);
        }

        @Override
        public final Builder jobConfiguration(Map<String, ConfigurationObject> jobConfiguration) {
            this.jobConfiguration = ConfigurationMapCopier.copy(jobConfiguration);
            return this;
        }

        public ProfileConfiguration build() {
            return new ProfileConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileConfiguration> {
        public Builder sessionConfiguration(Map<String, ConfigurationObject> var1);

        public Builder jobConfiguration(Map<String, ConfigurationObject> var1);
    }
}

