/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.SchemaVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterSchemaVersionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, RegisterSchemaVersionResponse> {
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(RegisterSchemaVersionResponse.getter(RegisterSchemaVersionResponse::schemaVersionId)).setter(RegisterSchemaVersionResponse.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(RegisterSchemaVersionResponse.getter(RegisterSchemaVersionResponse::versionNumber)).setter(RegisterSchemaVersionResponse.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RegisterSchemaVersionResponse.getter(RegisterSchemaVersionResponse::statusAsString)).setter(RegisterSchemaVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_ID_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterSchemaVersionResponse.memberNameToFieldInitializer();
    private final String schemaVersionId;
    private final Long versionNumber;
    private final String status;

    private RegisterSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaVersionId = builder.schemaVersionId;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
    }

    public final String schemaVersionId() {
        return this.schemaVersionId;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final SchemaVersionStatus status() {
        return SchemaVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSchemaVersionResponse)) {
            return false;
        }
        RegisterSchemaVersionResponse other = (RegisterSchemaVersionResponse)((Object)obj);
        return Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterSchemaVersionResponse").add("SchemaVersionId", (Object)this.schemaVersionId()).add("VersionNumber", (Object)this.versionNumber()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterSchemaVersionResponse, T> g) {
        return obj -> g.apply((RegisterSchemaVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String schemaVersionId;
        private Long versionNumber;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSchemaVersionResponse model) {
            super(model);
            this.schemaVersionId(model.schemaVersionId);
            this.versionNumber(model.versionNumber);
            this.status(model.status);
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RegisterSchemaVersionResponse build() {
            return new RegisterSchemaVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterSchemaVersionResponse> {
        public Builder schemaVersionId(String var1);

        public Builder versionNumber(Long var1);

        public Builder status(String var1);

        public Builder status(SchemaVersionStatus var1);
    }
}

