/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input parameters specific to updating Apache Iceberg tables in Glue Data Catalog, containing the update operations to
 * be applied to an existing Iceberg table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIcebergInput implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateIcebergInput.Builder, UpdateIcebergInput> {
    private static final SdkField<UpdateIcebergTableInput> UPDATE_ICEBERG_TABLE_INPUT_FIELD = SdkField
            .<UpdateIcebergTableInput> builder(MarshallingType.SDK_POJO).memberName("UpdateIcebergTableInput")
            .getter(getter(UpdateIcebergInput::updateIcebergTableInput)).setter(setter(Builder::updateIcebergTableInput))
            .constructor(UpdateIcebergTableInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateIcebergTableInput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UPDATE_ICEBERG_TABLE_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateIcebergTableInput updateIcebergTableInput;

    private UpdateIcebergInput(BuilderImpl builder) {
        this.updateIcebergTableInput = builder.updateIcebergTableInput;
    }

    /**
     * <p>
     * The specific update operations to be applied to the Iceberg table, containing a list of updates that define the
     * new state of the table including schema, partitions, and properties.
     * </p>
     * 
     * @return The specific update operations to be applied to the Iceberg table, containing a list of updates that
     *         define the new state of the table including schema, partitions, and properties.
     */
    public final UpdateIcebergTableInput updateIcebergTableInput() {
        return updateIcebergTableInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateIcebergTableInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIcebergInput)) {
            return false;
        }
        UpdateIcebergInput other = (UpdateIcebergInput) obj;
        return Objects.equals(updateIcebergTableInput(), other.updateIcebergTableInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIcebergInput").add("UpdateIcebergTableInput", updateIcebergTableInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateIcebergTableInput":
            return Optional.ofNullable(clazz.cast(updateIcebergTableInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdateIcebergTableInput", UPDATE_ICEBERG_TABLE_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIcebergInput, T> g) {
        return obj -> g.apply((UpdateIcebergInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateIcebergInput> {
        /**
         * <p>
         * The specific update operations to be applied to the Iceberg table, containing a list of updates that define
         * the new state of the table including schema, partitions, and properties.
         * </p>
         * 
         * @param updateIcebergTableInput
         *        The specific update operations to be applied to the Iceberg table, containing a list of updates that
         *        define the new state of the table including schema, partitions, and properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIcebergTableInput(UpdateIcebergTableInput updateIcebergTableInput);

        /**
         * <p>
         * The specific update operations to be applied to the Iceberg table, containing a list of updates that define
         * the new state of the table including schema, partitions, and properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateIcebergTableInput.Builder} avoiding
         * the need to create one manually via {@link UpdateIcebergTableInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateIcebergTableInput.Builder#build()} is called immediately
         * and its result is passed to {@link #updateIcebergTableInput(UpdateIcebergTableInput)}.
         * 
         * @param updateIcebergTableInput
         *        a consumer that will call methods on {@link UpdateIcebergTableInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateIcebergTableInput(UpdateIcebergTableInput)
         */
        default Builder updateIcebergTableInput(Consumer<UpdateIcebergTableInput.Builder> updateIcebergTableInput) {
            return updateIcebergTableInput(UpdateIcebergTableInput.builder().applyMutation(updateIcebergTableInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateIcebergTableInput updateIcebergTableInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIcebergInput model) {
            updateIcebergTableInput(model.updateIcebergTableInput);
        }

        public final UpdateIcebergTableInput.Builder getUpdateIcebergTableInput() {
            return updateIcebergTableInput != null ? updateIcebergTableInput.toBuilder() : null;
        }

        public final void setUpdateIcebergTableInput(UpdateIcebergTableInput.BuilderImpl updateIcebergTableInput) {
            this.updateIcebergTableInput = updateIcebergTableInput != null ? updateIcebergTableInput.build() : null;
        }

        @Override
        public final Builder updateIcebergTableInput(UpdateIcebergTableInput updateIcebergTableInput) {
            this.updateIcebergTableInput = updateIcebergTableInput;
            return this;
        }

        @Override
        public UpdateIcebergInput build() {
            return new UpdateIcebergInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
