/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the parameters in the config file of the dynamic transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformConfigParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformConfigParameter.Builder, TransformConfigParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TransformConfigParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TransformConfigParameter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALIDATION_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationRule").getter(getter(TransformConfigParameter::validationRule))
            .setter(setter(Builder::validationRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationRule").build()).build();

    private static final SdkField<String> VALIDATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationMessage").getter(getter(TransformConfigParameter::validationMessage))
            .setter(setter(Builder::validationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMessage").build()).build();

    private static final SdkField<List<String>> VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Value")
            .getter(getter(TransformConfigParameter::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListType").getter(getter(TransformConfigParameter::listTypeAsString)).setter(setter(Builder::listType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListType").build()).build();

    private static final SdkField<Boolean> IS_OPTIONAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOptional").getter(getter(TransformConfigParameter::isOptional)).setter(setter(Builder::isOptional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOptional").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            VALIDATION_RULE_FIELD, VALIDATION_MESSAGE_FIELD, VALUE_FIELD, LIST_TYPE_FIELD, IS_OPTIONAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String validationRule;

    private final String validationMessage;

    private final List<String> value;

    private final String listType;

    private final Boolean isOptional;

    private TransformConfigParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.validationRule = builder.validationRule;
        this.validationMessage = builder.validationMessage;
        this.value = builder.value;
        this.listType = builder.listType;
        this.isOptional = builder.isOptional;
    }

    /**
     * <p>
     * Specifies the name of the parameter in the config file of the dynamic transform.
     * </p>
     * 
     * @return Specifies the name of the parameter in the config file of the dynamic transform.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the parameter type in the config file of the dynamic transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ParamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the parameter type in the config file of the dynamic transform.
     * @see ParamType
     */
    public final ParamType type() {
        return ParamType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the parameter type in the config file of the dynamic transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ParamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the parameter type in the config file of the dynamic transform.
     * @see ParamType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the validation rule in the config file of the dynamic transform.
     * </p>
     * 
     * @return Specifies the validation rule in the config file of the dynamic transform.
     */
    public final String validationRule() {
        return validationRule;
    }

    /**
     * <p>
     * Specifies the validation message in the config file of the dynamic transform.
     * </p>
     * 
     * @return Specifies the validation message in the config file of the dynamic transform.
     */
    public final String validationMessage() {
        return validationMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Value property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasValue() {
        return value != null && !(value instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the value of the parameter in the config file of the dynamic transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValue} method.
     * </p>
     * 
     * @return Specifies the value of the parameter in the config file of the dynamic transform.
     */
    public final List<String> value() {
        return value;
    }

    /**
     * <p>
     * Specifies the list type of the parameter in the config file of the dynamic transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listType} will
     * return {@link ParamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listTypeAsString}.
     * </p>
     * 
     * @return Specifies the list type of the parameter in the config file of the dynamic transform.
     * @see ParamType
     */
    public final ParamType listType() {
        return ParamType.fromValue(listType);
    }

    /**
     * <p>
     * Specifies the list type of the parameter in the config file of the dynamic transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listType} will
     * return {@link ParamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listTypeAsString}.
     * </p>
     * 
     * @return Specifies the list type of the parameter in the config file of the dynamic transform.
     * @see ParamType
     */
    public final String listTypeAsString() {
        return listType;
    }

    /**
     * <p>
     * Specifies whether the parameter is optional or not in the config file of the dynamic transform.
     * </p>
     * 
     * @return Specifies whether the parameter is optional or not in the config file of the dynamic transform.
     */
    public final Boolean isOptional() {
        return isOptional;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationRule());
        hashCode = 31 * hashCode + Objects.hashCode(validationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasValue() ? value() : null);
        hashCode = 31 * hashCode + Objects.hashCode(listTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isOptional());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformConfigParameter)) {
            return false;
        }
        TransformConfigParameter other = (TransformConfigParameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(validationRule(), other.validationRule())
                && Objects.equals(validationMessage(), other.validationMessage()) && hasValue() == other.hasValue()
                && Objects.equals(value(), other.value()) && Objects.equals(listTypeAsString(), other.listTypeAsString())
                && Objects.equals(isOptional(), other.isOptional());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformConfigParameter").add("Name", name()).add("Type", typeAsString())
                .add("ValidationRule", validationRule()).add("ValidationMessage", validationMessage())
                .add("Value", hasValue() ? value() : null).add("ListType", listTypeAsString()).add("IsOptional", isOptional())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ValidationRule":
            return Optional.ofNullable(clazz.cast(validationRule()));
        case "ValidationMessage":
            return Optional.ofNullable(clazz.cast(validationMessage()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ListType":
            return Optional.ofNullable(clazz.cast(listTypeAsString()));
        case "IsOptional":
            return Optional.ofNullable(clazz.cast(isOptional()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ValidationRule", VALIDATION_RULE_FIELD);
        map.put("ValidationMessage", VALIDATION_MESSAGE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ListType", LIST_TYPE_FIELD);
        map.put("IsOptional", IS_OPTIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformConfigParameter, T> g) {
        return obj -> g.apply((TransformConfigParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformConfigParameter> {
        /**
         * <p>
         * Specifies the name of the parameter in the config file of the dynamic transform.
         * </p>
         * 
         * @param name
         *        Specifies the name of the parameter in the config file of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the parameter type in the config file of the dynamic transform.
         * </p>
         * 
         * @param type
         *        Specifies the parameter type in the config file of the dynamic transform.
         * @see ParamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParamType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the parameter type in the config file of the dynamic transform.
         * </p>
         * 
         * @param type
         *        Specifies the parameter type in the config file of the dynamic transform.
         * @see ParamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParamType
         */
        Builder type(ParamType type);

        /**
         * <p>
         * Specifies the validation rule in the config file of the dynamic transform.
         * </p>
         * 
         * @param validationRule
         *        Specifies the validation rule in the config file of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationRule(String validationRule);

        /**
         * <p>
         * Specifies the validation message in the config file of the dynamic transform.
         * </p>
         * 
         * @param validationMessage
         *        Specifies the validation message in the config file of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMessage(String validationMessage);

        /**
         * <p>
         * Specifies the value of the parameter in the config file of the dynamic transform.
         * </p>
         * 
         * @param value
         *        Specifies the value of the parameter in the config file of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Collection<String> value);

        /**
         * <p>
         * Specifies the value of the parameter in the config file of the dynamic transform.
         * </p>
         * 
         * @param value
         *        Specifies the value of the parameter in the config file of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String... value);

        /**
         * <p>
         * Specifies the list type of the parameter in the config file of the dynamic transform.
         * </p>
         * 
         * @param listType
         *        Specifies the list type of the parameter in the config file of the dynamic transform.
         * @see ParamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParamType
         */
        Builder listType(String listType);

        /**
         * <p>
         * Specifies the list type of the parameter in the config file of the dynamic transform.
         * </p>
         * 
         * @param listType
         *        Specifies the list type of the parameter in the config file of the dynamic transform.
         * @see ParamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParamType
         */
        Builder listType(ParamType listType);

        /**
         * <p>
         * Specifies whether the parameter is optional or not in the config file of the dynamic transform.
         * </p>
         * 
         * @param isOptional
         *        Specifies whether the parameter is optional or not in the config file of the dynamic transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOptional(Boolean isOptional);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String validationRule;

        private String validationMessage;

        private List<String> value = DefaultSdkAutoConstructList.getInstance();

        private String listType;

        private Boolean isOptional;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformConfigParameter model) {
            name(model.name);
            type(model.type);
            validationRule(model.validationRule);
            validationMessage(model.validationMessage);
            value(model.value);
            listType(model.listType);
            isOptional(model.isOptional);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParamType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValidationRule() {
            return validationRule;
        }

        public final void setValidationRule(String validationRule) {
            this.validationRule = validationRule;
        }

        @Override
        public final Builder validationRule(String validationRule) {
            this.validationRule = validationRule;
            return this;
        }

        public final String getValidationMessage() {
            return validationMessage;
        }

        public final void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        @Override
        public final Builder validationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
            return this;
        }

        public final Collection<String> getValue() {
            if (value instanceof SdkAutoConstructList) {
                return null;
            }
            return value;
        }

        public final void setValue(Collection<String> value) {
            this.value = EnclosedInStringPropertiesCopier.copy(value);
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = EnclosedInStringPropertiesCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String... value) {
            value(Arrays.asList(value));
            return this;
        }

        public final String getListType() {
            return listType;
        }

        public final void setListType(String listType) {
            this.listType = listType;
        }

        @Override
        public final Builder listType(String listType) {
            this.listType = listType;
            return this;
        }

        @Override
        public final Builder listType(ParamType listType) {
            this.listType(listType == null ? null : listType.toString());
            return this;
        }

        public final Boolean getIsOptional() {
            return isOptional;
        }

        public final void setIsOptional(Boolean isOptional) {
            this.isOptional = isOptional;
        }

        @Override
        public final Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        @Override
        public TransformConfigParameter build() {
            return new TransformConfigParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
