/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When there are multiple versions of a blueprint and the latest version has some errors, this attribute indicates the
 * last successful blueprint definition that is available with the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastActiveDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<LastActiveDefinition.Builder, LastActiveDefinition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LastActiveDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(LastActiveDefinition::lastModifiedOn))
            .setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<String> PARAMETER_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterSpec").getter(getter(LastActiveDefinition::parameterSpec))
            .setter(setter(Builder::parameterSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterSpec").build()).build();

    private static final SdkField<String> BLUEPRINT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintLocation").getter(getter(LastActiveDefinition::blueprintLocation))
            .setter(setter(Builder::blueprintLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintLocation").build()).build();

    private static final SdkField<String> BLUEPRINT_SERVICE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintServiceLocation").getter(getter(LastActiveDefinition::blueprintServiceLocation))
            .setter(setter(Builder::blueprintServiceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintServiceLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            LAST_MODIFIED_ON_FIELD, PARAMETER_SPEC_FIELD, BLUEPRINT_LOCATION_FIELD, BLUEPRINT_SERVICE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Instant lastModifiedOn;

    private final String parameterSpec;

    private final String blueprintLocation;

    private final String blueprintServiceLocation;

    private LastActiveDefinition(BuilderImpl builder) {
        this.description = builder.description;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.parameterSpec = builder.parameterSpec;
        this.blueprintLocation = builder.blueprintLocation;
        this.blueprintServiceLocation = builder.blueprintServiceLocation;
    }

    /**
     * <p>
     * The description of the blueprint.
     * </p>
     * 
     * @return The description of the blueprint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time the blueprint was last modified.
     * </p>
     * 
     * @return The date and time the blueprint was last modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * A JSON string specifying the parameters for the blueprint.
     * </p>
     * 
     * @return A JSON string specifying the parameters for the blueprint.
     */
    public final String parameterSpec() {
        return parameterSpec;
    }

    /**
     * <p>
     * Specifies a path in Amazon S3 where the blueprint is published by the Glue developer.
     * </p>
     * 
     * @return Specifies a path in Amazon S3 where the blueprint is published by the Glue developer.
     */
    public final String blueprintLocation() {
        return blueprintLocation;
    }

    /**
     * <p>
     * Specifies a path in Amazon S3 where the blueprint is copied when you create or update the blueprint.
     * </p>
     * 
     * @return Specifies a path in Amazon S3 where the blueprint is copied when you create or update the blueprint.
     */
    public final String blueprintServiceLocation() {
        return blueprintServiceLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(parameterSpec());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintLocation());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintServiceLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastActiveDefinition)) {
            return false;
        }
        LastActiveDefinition other = (LastActiveDefinition) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(lastModifiedOn(), other.lastModifiedOn())
                && Objects.equals(parameterSpec(), other.parameterSpec())
                && Objects.equals(blueprintLocation(), other.blueprintLocation())
                && Objects.equals(blueprintServiceLocation(), other.blueprintServiceLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastActiveDefinition").add("Description", description()).add("LastModifiedOn", lastModifiedOn())
                .add("ParameterSpec", parameterSpec()).add("BlueprintLocation", blueprintLocation())
                .add("BlueprintServiceLocation", blueprintServiceLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "ParameterSpec":
            return Optional.ofNullable(clazz.cast(parameterSpec()));
        case "BlueprintLocation":
            return Optional.ofNullable(clazz.cast(blueprintLocation()));
        case "BlueprintServiceLocation":
            return Optional.ofNullable(clazz.cast(blueprintServiceLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
        map.put("ParameterSpec", PARAMETER_SPEC_FIELD);
        map.put("BlueprintLocation", BLUEPRINT_LOCATION_FIELD);
        map.put("BlueprintServiceLocation", BLUEPRINT_SERVICE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastActiveDefinition, T> g) {
        return obj -> g.apply((LastActiveDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastActiveDefinition> {
        /**
         * <p>
         * The description of the blueprint.
         * </p>
         * 
         * @param description
         *        The description of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time the blueprint was last modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        The date and time the blueprint was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * A JSON string specifying the parameters for the blueprint.
         * </p>
         * 
         * @param parameterSpec
         *        A JSON string specifying the parameters for the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSpec(String parameterSpec);

        /**
         * <p>
         * Specifies a path in Amazon S3 where the blueprint is published by the Glue developer.
         * </p>
         * 
         * @param blueprintLocation
         *        Specifies a path in Amazon S3 where the blueprint is published by the Glue developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintLocation(String blueprintLocation);

        /**
         * <p>
         * Specifies a path in Amazon S3 where the blueprint is copied when you create or update the blueprint.
         * </p>
         * 
         * @param blueprintServiceLocation
         *        Specifies a path in Amazon S3 where the blueprint is copied when you create or update the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintServiceLocation(String blueprintServiceLocation);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Instant lastModifiedOn;

        private String parameterSpec;

        private String blueprintLocation;

        private String blueprintServiceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(LastActiveDefinition model) {
            description(model.description);
            lastModifiedOn(model.lastModifiedOn);
            parameterSpec(model.parameterSpec);
            blueprintLocation(model.blueprintLocation);
            blueprintServiceLocation(model.blueprintServiceLocation);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getParameterSpec() {
            return parameterSpec;
        }

        public final void setParameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
        }

        @Override
        public final Builder parameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
            return this;
        }

        public final String getBlueprintLocation() {
            return blueprintLocation;
        }

        public final void setBlueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
        }

        @Override
        public final Builder blueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
            return this;
        }

        public final String getBlueprintServiceLocation() {
            return blueprintServiceLocation;
        }

        public final void setBlueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
        }

        @Override
        public final Builder blueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
            return this;
        }

        @Override
        public LastActiveDefinition build() {
            return new LastActiveDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
