/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration parameters required to create a new Iceberg table in the Glue Data Catalog, including table
 * properties and metadata specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIcebergTableInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateIcebergTableInput.Builder, CreateIcebergTableInput> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(CreateIcebergTableInput::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<IcebergSchema> SCHEMA_FIELD = SdkField.<IcebergSchema> builder(MarshallingType.SDK_POJO)
            .memberName("Schema").getter(getter(CreateIcebergTableInput::schema)).setter(setter(Builder::schema))
            .constructor(IcebergSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<IcebergPartitionSpec> PARTITION_SPEC_FIELD = SdkField
            .<IcebergPartitionSpec> builder(MarshallingType.SDK_POJO).memberName("PartitionSpec")
            .getter(getter(CreateIcebergTableInput::partitionSpec)).setter(setter(Builder::partitionSpec))
            .constructor(IcebergPartitionSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSpec").build()).build();

    private static final SdkField<IcebergSortOrder> WRITE_ORDER_FIELD = SdkField
            .<IcebergSortOrder> builder(MarshallingType.SDK_POJO).memberName("WriteOrder")
            .getter(getter(CreateIcebergTableInput::writeOrder)).setter(setter(Builder::writeOrder))
            .constructor(IcebergSortOrder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteOrder").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(CreateIcebergTableInput::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, SCHEMA_FIELD,
            PARTITION_SPEC_FIELD, WRITE_ORDER_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String location;

    private final IcebergSchema schema;

    private final IcebergPartitionSpec partitionSpec;

    private final IcebergSortOrder writeOrder;

    private final Map<String, String> properties;

    private CreateIcebergTableInput(BuilderImpl builder) {
        this.location = builder.location;
        this.schema = builder.schema;
        this.partitionSpec = builder.partitionSpec;
        this.writeOrder = builder.writeOrder;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The S3 location where the Iceberg table data will be stored.
     * </p>
     * 
     * @return The S3 location where the Iceberg table data will be stored.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The schema definition that specifies the structure, field types, and metadata for the Iceberg table.
     * </p>
     * 
     * @return The schema definition that specifies the structure, field types, and metadata for the Iceberg table.
     */
    public final IcebergSchema schema() {
        return schema;
    }

    /**
     * <p>
     * The partitioning specification that defines how the Iceberg table data will be organized and partitioned for
     * optimal query performance.
     * </p>
     * 
     * @return The partitioning specification that defines how the Iceberg table data will be organized and partitioned
     *         for optimal query performance.
     */
    public final IcebergPartitionSpec partitionSpec() {
        return partitionSpec;
    }

    /**
     * <p>
     * The sort order specification that defines how data should be ordered within each partition to optimize query
     * performance.
     * </p>
     * 
     * @return The sort order specification that defines how data should be ordered within each partition to optimize
     *         query performance.
     */
    public final IcebergSortOrder writeOrder() {
        return writeOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs of additional table properties and configuration settings for the Iceberg table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return Key-value pairs of additional table properties and configuration settings for the Iceberg table.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(partitionSpec());
        hashCode = 31 * hashCode + Objects.hashCode(writeOrder());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIcebergTableInput)) {
            return false;
        }
        CreateIcebergTableInput other = (CreateIcebergTableInput) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(schema(), other.schema())
                && Objects.equals(partitionSpec(), other.partitionSpec()) && Objects.equals(writeOrder(), other.writeOrder())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIcebergTableInput").add("Location", location()).add("Schema", schema())
                .add("PartitionSpec", partitionSpec()).add("WriteOrder", writeOrder())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "PartitionSpec":
            return Optional.ofNullable(clazz.cast(partitionSpec()));
        case "WriteOrder":
            return Optional.ofNullable(clazz.cast(writeOrder()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Location", LOCATION_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("PartitionSpec", PARTITION_SPEC_FIELD);
        map.put("WriteOrder", WRITE_ORDER_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIcebergTableInput, T> g) {
        return obj -> g.apply((CreateIcebergTableInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateIcebergTableInput> {
        /**
         * <p>
         * The S3 location where the Iceberg table data will be stored.
         * </p>
         * 
         * @param location
         *        The S3 location where the Iceberg table data will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The schema definition that specifies the structure, field types, and metadata for the Iceberg table.
         * </p>
         * 
         * @param schema
         *        The schema definition that specifies the structure, field types, and metadata for the Iceberg table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(IcebergSchema schema);

        /**
         * <p>
         * The schema definition that specifies the structure, field types, and metadata for the Iceberg table.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergSchema.Builder} avoiding the need
         * to create one manually via {@link IcebergSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #schema(IcebergSchema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link IcebergSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(IcebergSchema)
         */
        default Builder schema(Consumer<IcebergSchema.Builder> schema) {
            return schema(IcebergSchema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The partitioning specification that defines how the Iceberg table data will be organized and partitioned for
         * optimal query performance.
         * </p>
         * 
         * @param partitionSpec
         *        The partitioning specification that defines how the Iceberg table data will be organized and
         *        partitioned for optimal query performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSpec(IcebergPartitionSpec partitionSpec);

        /**
         * <p>
         * The partitioning specification that defines how the Iceberg table data will be organized and partitioned for
         * optimal query performance.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergPartitionSpec.Builder} avoiding
         * the need to create one manually via {@link IcebergPartitionSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergPartitionSpec.Builder#build()} is called immediately and
         * its result is passed to {@link #partitionSpec(IcebergPartitionSpec)}.
         * 
         * @param partitionSpec
         *        a consumer that will call methods on {@link IcebergPartitionSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionSpec(IcebergPartitionSpec)
         */
        default Builder partitionSpec(Consumer<IcebergPartitionSpec.Builder> partitionSpec) {
            return partitionSpec(IcebergPartitionSpec.builder().applyMutation(partitionSpec).build());
        }

        /**
         * <p>
         * The sort order specification that defines how data should be ordered within each partition to optimize query
         * performance.
         * </p>
         * 
         * @param writeOrder
         *        The sort order specification that defines how data should be ordered within each partition to optimize
         *        query performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeOrder(IcebergSortOrder writeOrder);

        /**
         * <p>
         * The sort order specification that defines how data should be ordered within each partition to optimize query
         * performance.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergSortOrder.Builder} avoiding the
         * need to create one manually via {@link IcebergSortOrder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergSortOrder.Builder#build()} is called immediately and its
         * result is passed to {@link #writeOrder(IcebergSortOrder)}.
         * 
         * @param writeOrder
         *        a consumer that will call methods on {@link IcebergSortOrder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeOrder(IcebergSortOrder)
         */
        default Builder writeOrder(Consumer<IcebergSortOrder.Builder> writeOrder) {
            return writeOrder(IcebergSortOrder.builder().applyMutation(writeOrder).build());
        }

        /**
         * <p>
         * Key-value pairs of additional table properties and configuration settings for the Iceberg table.
         * </p>
         * 
         * @param properties
         *        Key-value pairs of additional table properties and configuration settings for the Iceberg table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private IcebergSchema schema;

        private IcebergPartitionSpec partitionSpec;

        private IcebergSortOrder writeOrder;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIcebergTableInput model) {
            location(model.location);
            schema(model.schema);
            partitionSpec(model.partitionSpec);
            writeOrder(model.writeOrder);
            properties(model.properties);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final IcebergSchema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(IcebergSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(IcebergSchema schema) {
            this.schema = schema;
            return this;
        }

        public final IcebergPartitionSpec.Builder getPartitionSpec() {
            return partitionSpec != null ? partitionSpec.toBuilder() : null;
        }

        public final void setPartitionSpec(IcebergPartitionSpec.BuilderImpl partitionSpec) {
            this.partitionSpec = partitionSpec != null ? partitionSpec.build() : null;
        }

        @Override
        public final Builder partitionSpec(IcebergPartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            return this;
        }

        public final IcebergSortOrder.Builder getWriteOrder() {
            return writeOrder != null ? writeOrder.toBuilder() : null;
        }

        public final void setWriteOrder(IcebergSortOrder.BuilderImpl writeOrder) {
            this.writeOrder = writeOrder != null ? writeOrder.build() : null;
        }

        @Override
        public final Builder writeOrder(IcebergSortOrder writeOrder) {
            this.writeOrder = writeOrder;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringToStringMapCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringToStringMapCopier.copy(properties);
            return this;
        }

        @Override
        public CreateIcebergTableInput build() {
            return new CreateIcebergTableInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
