/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Brief information about a supported connection type returned by the <code>ListConnectionTypes</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionTypeBrief implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionTypeBrief.Builder, ConnectionTypeBrief> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(ConnectionTypeBrief::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(ConnectionTypeBrief::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Vendor")
            .getter(getter(ConnectionTypeBrief::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectionTypeBrief::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(ConnectionTypeBrief::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.<Capabilities> builder(MarshallingType.SDK_POJO)
            .memberName("Capabilities").getter(getter(ConnectionTypeBrief::capabilities)).setter(setter(Builder::capabilities))
            .constructor(Capabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<String> LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogoUrl").getter(getter(ConnectionTypeBrief::logoUrl)).setter(setter(Builder::logoUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoUrl").build()).build();

    private static final SdkField<List<ConnectionTypeVariant>> CONNECTION_TYPE_VARIANTS_FIELD = SdkField
            .<List<ConnectionTypeVariant>> builder(MarshallingType.LIST)
            .memberName("ConnectionTypeVariants")
            .getter(getter(ConnectionTypeBrief::connectionTypeVariants))
            .setter(setter(Builder::connectionTypeVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTypeVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectionTypeVariant> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionTypeVariant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD,
            DISPLAY_NAME_FIELD, VENDOR_FIELD, DESCRIPTION_FIELD, CATEGORIES_FIELD, CAPABILITIES_FIELD, LOGO_URL_FIELD,
            CONNECTION_TYPE_VARIANTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionType;

    private final String displayName;

    private final String vendor;

    private final String description;

    private final List<String> categories;

    private final Capabilities capabilities;

    private final String logoUrl;

    private final List<ConnectionTypeVariant> connectionTypeVariants;

    private ConnectionTypeBrief(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.displayName = builder.displayName;
        this.vendor = builder.vendor;
        this.description = builder.description;
        this.categories = builder.categories;
        this.capabilities = builder.capabilities;
        this.logoUrl = builder.logoUrl;
        this.connectionTypeVariants = builder.connectionTypeVariants;
    }

    /**
     * <p>
     * The name of the connection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The name of the connection type.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The name of the connection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The name of the connection type.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * The human-readable name for the connection type that is displayed in the Glue console.
     * </p>
     * 
     * @return The human-readable name for the connection type that is displayed in the Glue console.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The name of the vendor or provider that created or maintains this connection type.
     * </p>
     * 
     * @return The name of the vendor or provider that created or maintains this connection type.
     */
    public final String vendor() {
        return vendor;
    }

    /**
     * <p>
     * A description of the connection type.
     * </p>
     * 
     * @return A description of the connection type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of categories that this connection type belongs to. Categories help users filter and find appropriate
     * connection types based on their use cases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return A list of categories that this connection type belongs to. Categories help users filter and find
     *         appropriate connection types based on their use cases.
     */
    public final List<String> categories() {
        return categories;
    }

    /**
     * <p>
     * The supported authentication types, data interface types (compute environments), and data operations of the
     * connector.
     * </p>
     * 
     * @return The supported authentication types, data interface types (compute environments), and data operations of
     *         the connector.
     */
    public final Capabilities capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The URL of the logo associated with a connection type.
     * </p>
     * 
     * @return The URL of the logo associated with a connection type.
     */
    public final String logoUrl() {
        return logoUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionTypeVariants property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectionTypeVariants() {
        return connectionTypeVariants != null && !(connectionTypeVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of variants available for this connection type. Different variants may provide specialized configurations
     * for specific use cases or implementations of the same general connection type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionTypeVariants} method.
     * </p>
     * 
     * @return A list of variants available for this connection type. Different variants may provide specialized
     *         configurations for specific use cases or implementations of the same general connection type.
     */
    public final List<ConnectionTypeVariant> connectionTypeVariants() {
        return connectionTypeVariants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionTypeVariants() ? connectionTypeVariants() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeBrief)) {
            return false;
        }
        ConnectionTypeBrief other = (ConnectionTypeBrief) obj;
        return Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(vendor(), other.vendor())
                && Objects.equals(description(), other.description()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories()) && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(logoUrl(), other.logoUrl()) && hasConnectionTypeVariants() == other.hasConnectionTypeVariants()
                && Objects.equals(connectionTypeVariants(), other.connectionTypeVariants());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionTypeBrief").add("ConnectionType", connectionTypeAsString())
                .add("DisplayName", displayName()).add("Vendor", vendor()).add("Description", description())
                .add("Categories", hasCategories() ? categories() : null).add("Capabilities", capabilities())
                .add("LogoUrl", logoUrl())
                .add("ConnectionTypeVariants", hasConnectionTypeVariants() ? connectionTypeVariants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "LogoUrl":
            return Optional.ofNullable(clazz.cast(logoUrl()));
        case "ConnectionTypeVariants":
            return Optional.ofNullable(clazz.cast(connectionTypeVariants()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Vendor", VENDOR_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("LogoUrl", LOGO_URL_FIELD);
        map.put("ConnectionTypeVariants", CONNECTION_TYPE_VARIANTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeBrief, T> g) {
        return obj -> g.apply((ConnectionTypeBrief) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionTypeBrief> {
        /**
         * <p>
         * The name of the connection type.
         * </p>
         * 
         * @param connectionType
         *        The name of the connection type.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The name of the connection type.
         * </p>
         * 
         * @param connectionType
         *        The name of the connection type.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * The human-readable name for the connection type that is displayed in the Glue console.
         * </p>
         * 
         * @param displayName
         *        The human-readable name for the connection type that is displayed in the Glue console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The name of the vendor or provider that created or maintains this connection type.
         * </p>
         * 
         * @param vendor
         *        The name of the vendor or provider that created or maintains this connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * A description of the connection type.
         * </p>
         * 
         * @param description
         *        A description of the connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of categories that this connection type belongs to. Categories help users filter and find appropriate
         * connection types based on their use cases.
         * </p>
         * 
         * @param categories
         *        A list of categories that this connection type belongs to. Categories help users filter and find
         *        appropriate connection types based on their use cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<String> categories);

        /**
         * <p>
         * A list of categories that this connection type belongs to. Categories help users filter and find appropriate
         * connection types based on their use cases.
         * </p>
         * 
         * @param categories
         *        A list of categories that this connection type belongs to. Categories help users filter and find
         *        appropriate connection types based on their use cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(String... categories);

        /**
         * <p>
         * The supported authentication types, data interface types (compute environments), and data operations of the
         * connector.
         * </p>
         * 
         * @param capabilities
         *        The supported authentication types, data interface types (compute environments), and data operations
         *        of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capabilities capabilities);

        /**
         * <p>
         * The supported authentication types, data interface types (compute environments), and data operations of the
         * connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capabilities.Builder} avoiding the need
         * to create one manually via {@link Capabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilities(Capabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link Capabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(Capabilities)
         */
        default Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return capabilities(Capabilities.builder().applyMutation(capabilities).build());
        }

        /**
         * <p>
         * The URL of the logo associated with a connection type.
         * </p>
         * 
         * @param logoUrl
         *        The URL of the logo associated with a connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoUrl(String logoUrl);

        /**
         * <p>
         * A list of variants available for this connection type. Different variants may provide specialized
         * configurations for specific use cases or implementations of the same general connection type.
         * </p>
         * 
         * @param connectionTypeVariants
         *        A list of variants available for this connection type. Different variants may provide specialized
         *        configurations for specific use cases or implementations of the same general connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTypeVariants(Collection<ConnectionTypeVariant> connectionTypeVariants);

        /**
         * <p>
         * A list of variants available for this connection type. Different variants may provide specialized
         * configurations for specific use cases or implementations of the same general connection type.
         * </p>
         * 
         * @param connectionTypeVariants
         *        A list of variants available for this connection type. Different variants may provide specialized
         *        configurations for specific use cases or implementations of the same general connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTypeVariants(ConnectionTypeVariant... connectionTypeVariants);

        /**
         * <p>
         * A list of variants available for this connection type. Different variants may provide specialized
         * configurations for specific use cases or implementations of the same general connection type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.ConnectionTypeVariant.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.ConnectionTypeVariant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.ConnectionTypeVariant.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionTypeVariants(List<ConnectionTypeVariant>)}.
         * 
         * @param connectionTypeVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.ConnectionTypeVariant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionTypeVariants(java.util.Collection<ConnectionTypeVariant>)
         */
        Builder connectionTypeVariants(Consumer<ConnectionTypeVariant.Builder>... connectionTypeVariants);
    }

    static final class BuilderImpl implements Builder {
        private String connectionType;

        private String displayName;

        private String vendor;

        private String description;

        private List<String> categories = DefaultSdkAutoConstructList.getInstance();

        private Capabilities capabilities;

        private String logoUrl;

        private List<ConnectionTypeVariant> connectionTypeVariants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeBrief model) {
            connectionType(model.connectionType);
            displayName(model.displayName);
            vendor(model.vendor);
            description(model.description);
            categories(model.categories);
            capabilities(model.capabilities);
            logoUrl(model.logoUrl);
            connectionTypeVariants(model.connectionTypeVariants);
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCategories() {
            if (categories instanceof SdkAutoConstructList) {
                return null;
            }
            return categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = ListOfStringCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = ListOfStringCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getLogoUrl() {
            return logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final List<ConnectionTypeVariant.Builder> getConnectionTypeVariants() {
            List<ConnectionTypeVariant.Builder> result = ConnectionTypeVariantListCopier
                    .copyToBuilder(this.connectionTypeVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionTypeVariants(Collection<ConnectionTypeVariant.BuilderImpl> connectionTypeVariants) {
            this.connectionTypeVariants = ConnectionTypeVariantListCopier.copyFromBuilder(connectionTypeVariants);
        }

        @Override
        public final Builder connectionTypeVariants(Collection<ConnectionTypeVariant> connectionTypeVariants) {
            this.connectionTypeVariants = ConnectionTypeVariantListCopier.copy(connectionTypeVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypeVariants(ConnectionTypeVariant... connectionTypeVariants) {
            connectionTypeVariants(Arrays.asList(connectionTypeVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypeVariants(Consumer<ConnectionTypeVariant.Builder>... connectionTypeVariants) {
            connectionTypeVariants(Stream.of(connectionTypeVariants)
                    .map(c -> ConnectionTypeVariant.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConnectionTypeBrief build() {
            return new ConnectionTypeBrief(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
