/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information for an analytical engine to validate a view, prior to persisting the view
 * metadata. Used in the case of direct <code>UpdateTable</code> or <code>CreateTable</code> API calls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewValidation implements SdkPojo, Serializable, ToCopyableBuilder<ViewValidation.Builder, ViewValidation> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Dialect")
            .getter(getter(ViewValidation::dialectAsString)).setter(setter(Builder::dialect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()).build();

    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DialectVersion").getter(getter(ViewValidation::dialectVersion)).setter(setter(Builder::dialectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()).build();

    private static final SdkField<String> VIEW_VALIDATION_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewValidationText").getter(getter(ViewValidation::viewValidationText))
            .setter(setter(Builder::viewValidationText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewValidationText").build())
            .build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(ViewValidation::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ViewValidation::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ViewValidation::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD,
            DIALECT_VERSION_FIELD, VIEW_VALIDATION_TEXT_FIELD, UPDATE_TIME_FIELD, STATE_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dialect;

    private final String dialectVersion;

    private final String viewValidationText;

    private final Instant updateTime;

    private final String state;

    private final ErrorDetail error;

    private ViewValidation(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
        this.viewValidationText = builder.viewValidationText;
        this.updateTime = builder.updateTime;
        this.state = builder.state;
        this.error = builder.error;
    }

    /**
     * <p>
     * The dialect of the query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return The dialect of the query engine.
     * @see ViewDialect
     */
    public final ViewDialect dialect() {
        return ViewDialect.fromValue(dialect);
    }

    /**
     * <p>
     * The dialect of the query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return The dialect of the query engine.
     * @see ViewDialect
     */
    public final String dialectAsString() {
        return dialect;
    }

    /**
     * <p>
     * The version of the dialect of the query engine. For example, 3.0.0.
     * </p>
     * 
     * @return The version of the dialect of the query engine. For example, 3.0.0.
     */
    public final String dialectVersion() {
        return dialectVersion;
    }

    /**
     * <p>
     * The <code>SELECT</code> query that defines the view, as provided by the customer.
     * </p>
     * 
     * @return The <code>SELECT</code> query that defines the view, as provided by the customer.
     */
    public final String viewValidationText() {
        return viewValidationText;
    }

    /**
     * <p>
     * The time of the last update.
     * </p>
     * 
     * @return The time of the last update.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The state of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the validation.
     * @see ResourceState
     */
    public final ResourceState state() {
        return ResourceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the validation.
     * @see ResourceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * An error associated with the validation.
     * </p>
     * 
     * @return An error associated with the validation.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(viewValidationText());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewValidation)) {
            return false;
        }
        ViewValidation other = (ViewValidation) obj;
        return Objects.equals(dialectAsString(), other.dialectAsString())
                && Objects.equals(dialectVersion(), other.dialectVersion())
                && Objects.equals(viewValidationText(), other.viewValidationText())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewValidation").add("Dialect", dialectAsString()).add("DialectVersion", dialectVersion())
                .add("ViewValidationText", viewValidationText()).add("UpdateTime", updateTime()).add("State", stateAsString())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dialect":
            return Optional.ofNullable(clazz.cast(dialectAsString()));
        case "DialectVersion":
            return Optional.ofNullable(clazz.cast(dialectVersion()));
        case "ViewValidationText":
            return Optional.ofNullable(clazz.cast(viewValidationText()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dialect", DIALECT_FIELD);
        map.put("DialectVersion", DIALECT_VERSION_FIELD);
        map.put("ViewValidationText", VIEW_VALIDATION_TEXT_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewValidation, T> g) {
        return obj -> g.apply((ViewValidation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewValidation> {
        /**
         * <p>
         * The dialect of the query engine.
         * </p>
         * 
         * @param dialect
         *        The dialect of the query engine.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(String dialect);

        /**
         * <p>
         * The dialect of the query engine.
         * </p>
         * 
         * @param dialect
         *        The dialect of the query engine.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(ViewDialect dialect);

        /**
         * <p>
         * The version of the dialect of the query engine. For example, 3.0.0.
         * </p>
         * 
         * @param dialectVersion
         *        The version of the dialect of the query engine. For example, 3.0.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialectVersion(String dialectVersion);

        /**
         * <p>
         * The <code>SELECT</code> query that defines the view, as provided by the customer.
         * </p>
         * 
         * @param viewValidationText
         *        The <code>SELECT</code> query that defines the view, as provided by the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewValidationText(String viewValidationText);

        /**
         * <p>
         * The time of the last update.
         * </p>
         * 
         * @param updateTime
         *        The time of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The state of the validation.
         * </p>
         * 
         * @param state
         *        The state of the validation.
         * @see ResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the validation.
         * </p>
         * 
         * @param state
         *        The state of the validation.
         * @see ResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceState
         */
        Builder state(ResourceState state);

        /**
         * <p>
         * An error associated with the validation.
         * </p>
         * 
         * @param error
         *        An error associated with the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * An error associated with the validation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dialect;

        private String dialectVersion;

        private String viewValidationText;

        private Instant updateTime;

        private String state;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewValidation model) {
            dialect(model.dialect);
            dialectVersion(model.dialectVersion);
            viewValidationText(model.viewValidationText);
            updateTime(model.updateTime);
            state(model.state);
            error(model.error);
        }

        public final String getDialect() {
            return dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        public final String getViewValidationText() {
            return viewValidationText;
        }

        public final void setViewValidationText(String viewValidationText) {
            this.viewValidationText = viewValidationText;
        }

        @Override
        public final Builder viewValidationText(String viewValidationText) {
            this.viewValidationText = viewValidationText;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public ViewValidation build() {
            return new ViewValidation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
