/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A node represents an Glue component (trigger, crawler, or job) on a workflow graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Node::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Node::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniqueId").getter(getter(Node::uniqueId)).setter(setter(Builder::uniqueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueId").build()).build();

    private static final SdkField<TriggerNodeDetails> TRIGGER_DETAILS_FIELD = SdkField
            .<TriggerNodeDetails> builder(MarshallingType.SDK_POJO).memberName("TriggerDetails")
            .getter(getter(Node::triggerDetails)).setter(setter(Builder::triggerDetails))
            .constructor(TriggerNodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerDetails").build()).build();

    private static final SdkField<JobNodeDetails> JOB_DETAILS_FIELD = SdkField.<JobNodeDetails> builder(MarshallingType.SDK_POJO)
            .memberName("JobDetails").getter(getter(Node::jobDetails)).setter(setter(Builder::jobDetails))
            .constructor(JobNodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDetails").build()).build();

    private static final SdkField<CrawlerNodeDetails> CRAWLER_DETAILS_FIELD = SdkField
            .<CrawlerNodeDetails> builder(MarshallingType.SDK_POJO).memberName("CrawlerDetails")
            .getter(getter(Node::crawlerDetails)).setter(setter(Builder::crawlerDetails))
            .constructor(CrawlerNodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            UNIQUE_ID_FIELD, TRIGGER_DETAILS_FIELD, JOB_DETAILS_FIELD, CRAWLER_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String uniqueId;

    private final TriggerNodeDetails triggerDetails;

    private final JobNodeDetails jobDetails;

    private final CrawlerNodeDetails crawlerDetails;

    private Node(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.uniqueId = builder.uniqueId;
        this.triggerDetails = builder.triggerDetails;
        this.jobDetails = builder.jobDetails;
        this.crawlerDetails = builder.crawlerDetails;
    }

    /**
     * <p>
     * The type of Glue component represented by the node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Glue component represented by the node.
     * @see NodeType
     */
    public final NodeType type() {
        return NodeType.fromValue(type);
    }

    /**
     * <p>
     * The type of Glue component represented by the node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Glue component represented by the node.
     * @see NodeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the Glue component represented by the node.
     * </p>
     * 
     * @return The name of the Glue component represented by the node.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique Id assigned to the node within the workflow.
     * </p>
     * 
     * @return The unique Id assigned to the node within the workflow.
     */
    public final String uniqueId() {
        return uniqueId;
    }

    /**
     * <p>
     * Details of the Trigger when the node represents a Trigger.
     * </p>
     * 
     * @return Details of the Trigger when the node represents a Trigger.
     */
    public final TriggerNodeDetails triggerDetails() {
        return triggerDetails;
    }

    /**
     * <p>
     * Details of the Job when the node represents a Job.
     * </p>
     * 
     * @return Details of the Job when the node represents a Job.
     */
    public final JobNodeDetails jobDetails() {
        return jobDetails;
    }

    /**
     * <p>
     * Details of the crawler when the node represents a crawler.
     * </p>
     * 
     * @return Details of the crawler when the node represents a crawler.
     */
    public final CrawlerNodeDetails crawlerDetails() {
        return crawlerDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(triggerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(uniqueId(), other.uniqueId()) && Objects.equals(triggerDetails(), other.triggerDetails())
                && Objects.equals(jobDetails(), other.jobDetails()) && Objects.equals(crawlerDetails(), other.crawlerDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Node").add("Type", typeAsString()).add("Name", name()).add("UniqueId", uniqueId())
                .add("TriggerDetails", triggerDetails()).add("JobDetails", jobDetails()).add("CrawlerDetails", crawlerDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "UniqueId":
            return Optional.ofNullable(clazz.cast(uniqueId()));
        case "TriggerDetails":
            return Optional.ofNullable(clazz.cast(triggerDetails()));
        case "JobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        case "CrawlerDetails":
            return Optional.ofNullable(clazz.cast(crawlerDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("UniqueId", UNIQUE_ID_FIELD);
        map.put("TriggerDetails", TRIGGER_DETAILS_FIELD);
        map.put("JobDetails", JOB_DETAILS_FIELD);
        map.put("CrawlerDetails", CRAWLER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * The type of Glue component represented by the node.
         * </p>
         * 
         * @param type
         *        The type of Glue component represented by the node.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of Glue component represented by the node.
         * </p>
         * 
         * @param type
         *        The type of Glue component represented by the node.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder type(NodeType type);

        /**
         * <p>
         * The name of the Glue component represented by the node.
         * </p>
         * 
         * @param name
         *        The name of the Glue component represented by the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique Id assigned to the node within the workflow.
         * </p>
         * 
         * @param uniqueId
         *        The unique Id assigned to the node within the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);

        /**
         * <p>
         * Details of the Trigger when the node represents a Trigger.
         * </p>
         * 
         * @param triggerDetails
         *        Details of the Trigger when the node represents a Trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerDetails(TriggerNodeDetails triggerDetails);

        /**
         * <p>
         * Details of the Trigger when the node represents a Trigger.
         * </p>
         * This is a convenience method that creates an instance of the {@link TriggerNodeDetails.Builder} avoiding the
         * need to create one manually via {@link TriggerNodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TriggerNodeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #triggerDetails(TriggerNodeDetails)}.
         * 
         * @param triggerDetails
         *        a consumer that will call methods on {@link TriggerNodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerDetails(TriggerNodeDetails)
         */
        default Builder triggerDetails(Consumer<TriggerNodeDetails.Builder> triggerDetails) {
            return triggerDetails(TriggerNodeDetails.builder().applyMutation(triggerDetails).build());
        }

        /**
         * <p>
         * Details of the Job when the node represents a Job.
         * </p>
         * 
         * @param jobDetails
         *        Details of the Job when the node represents a Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(JobNodeDetails jobDetails);

        /**
         * <p>
         * Details of the Job when the node represents a Job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobNodeDetails.Builder} avoiding the need
         * to create one manually via {@link JobNodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobNodeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #jobDetails(JobNodeDetails)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link JobNodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(JobNodeDetails)
         */
        default Builder jobDetails(Consumer<JobNodeDetails.Builder> jobDetails) {
            return jobDetails(JobNodeDetails.builder().applyMutation(jobDetails).build());
        }

        /**
         * <p>
         * Details of the crawler when the node represents a crawler.
         * </p>
         * 
         * @param crawlerDetails
         *        Details of the crawler when the node represents a crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerDetails(CrawlerNodeDetails crawlerDetails);

        /**
         * <p>
         * Details of the crawler when the node represents a crawler.
         * </p>
         * This is a convenience method that creates an instance of the {@link CrawlerNodeDetails.Builder} avoiding the
         * need to create one manually via {@link CrawlerNodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrawlerNodeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #crawlerDetails(CrawlerNodeDetails)}.
         * 
         * @param crawlerDetails
         *        a consumer that will call methods on {@link CrawlerNodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawlerDetails(CrawlerNodeDetails)
         */
        default Builder crawlerDetails(Consumer<CrawlerNodeDetails.Builder> crawlerDetails) {
            return crawlerDetails(CrawlerNodeDetails.builder().applyMutation(crawlerDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String uniqueId;

        private TriggerNodeDetails triggerDetails;

        private JobNodeDetails jobDetails;

        private CrawlerNodeDetails crawlerDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            type(model.type);
            name(model.name);
            uniqueId(model.uniqueId);
            triggerDetails(model.triggerDetails);
            jobDetails(model.jobDetails);
            crawlerDetails(model.crawlerDetails);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NodeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final TriggerNodeDetails.Builder getTriggerDetails() {
            return triggerDetails != null ? triggerDetails.toBuilder() : null;
        }

        public final void setTriggerDetails(TriggerNodeDetails.BuilderImpl triggerDetails) {
            this.triggerDetails = triggerDetails != null ? triggerDetails.build() : null;
        }

        @Override
        public final Builder triggerDetails(TriggerNodeDetails triggerDetails) {
            this.triggerDetails = triggerDetails;
            return this;
        }

        public final JobNodeDetails.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobNodeDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        @Override
        public final Builder jobDetails(JobNodeDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        public final CrawlerNodeDetails.Builder getCrawlerDetails() {
            return crawlerDetails != null ? crawlerDetails.toBuilder() : null;
        }

        public final void setCrawlerDetails(CrawlerNodeDetails.BuilderImpl crawlerDetails) {
            this.crawlerDetails = crawlerDetails != null ? crawlerDetails.build() : null;
        }

        @Override
        public final Builder crawlerDetails(CrawlerNodeDetails crawlerDetails) {
            this.crawlerDetails = crawlerDetails;
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
