/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectionTypesResponse extends GlueResponse implements
        ToCopyableBuilder<ListConnectionTypesResponse.Builder, ListConnectionTypesResponse> {
    private static final SdkField<List<ConnectionTypeBrief>> CONNECTION_TYPES_FIELD = SdkField
            .<List<ConnectionTypeBrief>> builder(MarshallingType.LIST)
            .memberName("ConnectionTypes")
            .getter(getter(ListConnectionTypesResponse::connectionTypes))
            .setter(setter(Builder::connectionTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectionTypeBrief> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionTypeBrief::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConnectionTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConnectionTypeBrief> connectionTypes;

    private final String nextToken;

    private ListConnectionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.connectionTypes = builder.connectionTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionTypes() {
        return connectionTypes != null && !(connectionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported connection
     * types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionTypes} method.
     * </p>
     * 
     * @return A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported
     *         connection types.
     */
    public final List<ConnectionTypeBrief> connectionTypes() {
        return connectionTypes;
    }

    /**
     * <p>
     * A continuation token, if the current list segment is not the last.
     * </p>
     * 
     * @return A continuation token, if the current list segment is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionTypes() ? connectionTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionTypesResponse)) {
            return false;
        }
        ListConnectionTypesResponse other = (ListConnectionTypesResponse) obj;
        return hasConnectionTypes() == other.hasConnectionTypes() && Objects.equals(connectionTypes(), other.connectionTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectionTypesResponse")
                .add("ConnectionTypes", hasConnectionTypes() ? connectionTypes() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionTypes":
            return Optional.ofNullable(clazz.cast(connectionTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionTypes", CONNECTION_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionTypesResponse, T> g) {
        return obj -> g.apply((ListConnectionTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectionTypesResponse> {
        /**
         * <p>
         * A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported
         * connection types.
         * </p>
         * 
         * @param connectionTypes
         *        A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported
         *        connection types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTypes(Collection<ConnectionTypeBrief> connectionTypes);

        /**
         * <p>
         * A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported
         * connection types.
         * </p>
         * 
         * @param connectionTypes
         *        A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported
         *        connection types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTypes(ConnectionTypeBrief... connectionTypes);

        /**
         * <p>
         * A list of <code>ConnectionTypeBrief</code> objects containing brief information about the supported
         * connection types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.ConnectionTypeBrief.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.ConnectionTypeBrief#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.ConnectionTypeBrief.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionTypes(List<ConnectionTypeBrief>)}.
         * 
         * @param connectionTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.ConnectionTypeBrief.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionTypes(java.util.Collection<ConnectionTypeBrief>)
         */
        Builder connectionTypes(Consumer<ConnectionTypeBrief.Builder>... connectionTypes);

        /**
         * <p>
         * A continuation token, if the current list segment is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the current list segment is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<ConnectionTypeBrief> connectionTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionTypesResponse model) {
            super(model);
            connectionTypes(model.connectionTypes);
            nextToken(model.nextToken);
        }

        public final List<ConnectionTypeBrief.Builder> getConnectionTypes() {
            List<ConnectionTypeBrief.Builder> result = ConnectionTypeListCopier.copyToBuilder(this.connectionTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionTypes(Collection<ConnectionTypeBrief.BuilderImpl> connectionTypes) {
            this.connectionTypes = ConnectionTypeListCopier.copyFromBuilder(connectionTypes);
        }

        @Override
        public final Builder connectionTypes(Collection<ConnectionTypeBrief> connectionTypes) {
            this.connectionTypes = ConnectionTypeListCopier.copy(connectionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypes(ConnectionTypeBrief... connectionTypes) {
            connectionTypes(Arrays.asList(connectionTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypes(Consumer<ConnectionTypeBrief.Builder>... connectionTypes) {
            connectionTypes(Stream.of(connectionTypes).map(c -> ConnectionTypeBrief.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectionTypesResponse build() {
            return new ListConnectionTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
