/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the sort order specification for an Iceberg table, determining how data should be ordered within partitions
 * to optimize query performance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergSortOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergSortOrder.Builder, IcebergSortOrder> {
    private static final SdkField<Integer> ORDER_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OrderId").getter(getter(IcebergSortOrder::orderId)).setter(setter(Builder::orderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()).build();

    private static final SdkField<List<IcebergSortField>> FIELDS_FIELD = SdkField
            .<List<IcebergSortField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(IcebergSortOrder::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IcebergSortField> builder(MarshallingType.SDK_POJO)
                                            .constructor(IcebergSortField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_ID_FIELD, FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer orderId;

    private final List<IcebergSortField> fields;

    private IcebergSortOrder(BuilderImpl builder) {
        this.orderId = builder.orderId;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * The unique identifier for this sort order specification within the Iceberg table's metadata.
     * </p>
     * 
     * @return The unique identifier for this sort order specification within the Iceberg table's metadata.
     */
    public final Integer orderId() {
        return orderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of fields and their sort directions that define the ordering criteria for the Iceberg table data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The list of fields and their sort directions that define the ordering criteria for the Iceberg table
     *         data.
     */
    public final List<IcebergSortField> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(orderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSortOrder)) {
            return false;
        }
        IcebergSortOrder other = (IcebergSortOrder) obj;
        return Objects.equals(orderId(), other.orderId()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergSortOrder").add("OrderId", orderId()).add("Fields", hasFields() ? fields() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderId":
            return Optional.ofNullable(clazz.cast(orderId()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrderId", ORDER_ID_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergSortOrder, T> g) {
        return obj -> g.apply((IcebergSortOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergSortOrder> {
        /**
         * <p>
         * The unique identifier for this sort order specification within the Iceberg table's metadata.
         * </p>
         * 
         * @param orderId
         *        The unique identifier for this sort order specification within the Iceberg table's metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderId(Integer orderId);

        /**
         * <p>
         * The list of fields and their sort directions that define the ordering criteria for the Iceberg table data.
         * </p>
         * 
         * @param fields
         *        The list of fields and their sort directions that define the ordering criteria for the Iceberg table
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<IcebergSortField> fields);

        /**
         * <p>
         * The list of fields and their sort directions that define the ordering criteria for the Iceberg table data.
         * </p>
         * 
         * @param fields
         *        The list of fields and their sort directions that define the ordering criteria for the Iceberg table
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(IcebergSortField... fields);

        /**
         * <p>
         * The list of fields and their sort directions that define the ordering criteria for the Iceberg table data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.IcebergSortField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.IcebergSortField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.IcebergSortField.Builder#build()} is called immediately and
         * its result is passed to {@link #fields(List<IcebergSortField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.IcebergSortField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<IcebergSortField>)
         */
        Builder fields(Consumer<IcebergSortField.Builder>... fields);
    }

    static final class BuilderImpl implements Builder {
        private Integer orderId;

        private List<IcebergSortField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSortOrder model) {
            orderId(model.orderId);
            fields(model.fields);
        }

        public final Integer getOrderId() {
            return orderId;
        }

        public final void setOrderId(Integer orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(Integer orderId) {
            this.orderId = orderId;
            return this;
        }

        public final List<IcebergSortField.Builder> getFields() {
            List<IcebergSortField.Builder> result = IcebergSortOrderFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<IcebergSortField.BuilderImpl> fields) {
            this.fields = IcebergSortOrderFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<IcebergSortField> fields) {
            this.fields = IcebergSortOrderFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(IcebergSortField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<IcebergSortField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> IcebergSortField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IcebergSortOrder build() {
            return new IcebergSortOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
