/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compaction metrics for Iceberg for the optimizer run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergCompactionMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergCompactionMetrics.Builder, IcebergCompactionMetrics> {
    private static final SdkField<Long> NUMBER_OF_BYTES_COMPACTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfBytesCompacted").getter(getter(IcebergCompactionMetrics::numberOfBytesCompacted))
            .setter(setter(Builder::numberOfBytesCompacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytesCompacted").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_FILES_COMPACTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfFilesCompacted").getter(getter(IcebergCompactionMetrics::numberOfFilesCompacted))
            .setter(setter(Builder::numberOfFilesCompacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFilesCompacted").build())
            .build();

    private static final SdkField<Double> DPU_HOURS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DpuHours").getter(getter(IcebergCompactionMetrics::dpuHours)).setter(setter(Builder::dpuHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpuHours").build()).build();

    private static final SdkField<Integer> NUMBER_OF_DPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDpus").getter(getter(IcebergCompactionMetrics::numberOfDpus))
            .setter(setter(Builder::numberOfDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()).build();

    private static final SdkField<Double> JOB_DURATION_IN_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("JobDurationInHour").getter(getter(IcebergCompactionMetrics::jobDurationInHour))
            .setter(setter(Builder::jobDurationInHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_BYTES_COMPACTED_FIELD, NUMBER_OF_FILES_COMPACTED_FIELD, DPU_HOURS_FIELD, NUMBER_OF_DPUS_FIELD,
            JOB_DURATION_IN_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long numberOfBytesCompacted;

    private final Long numberOfFilesCompacted;

    private final Double dpuHours;

    private final Integer numberOfDpus;

    private final Double jobDurationInHour;

    private IcebergCompactionMetrics(BuilderImpl builder) {
        this.numberOfBytesCompacted = builder.numberOfBytesCompacted;
        this.numberOfFilesCompacted = builder.numberOfFilesCompacted;
        this.dpuHours = builder.dpuHours;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    /**
     * <p>
     * The number of bytes removed by the compaction job run.
     * </p>
     * 
     * @return The number of bytes removed by the compaction job run.
     */
    public final Long numberOfBytesCompacted() {
        return numberOfBytesCompacted;
    }

    /**
     * <p>
     * The number of files removed by the compaction job run.
     * </p>
     * 
     * @return The number of files removed by the compaction job run.
     */
    public final Long numberOfFilesCompacted() {
        return numberOfFilesCompacted;
    }

    /**
     * <p>
     * The number of DPU hours consumed by the job.
     * </p>
     * 
     * @return The number of DPU hours consumed by the job.
     */
    public final Double dpuHours() {
        return dpuHours;
    }

    /**
     * <p>
     * The number of DPUs consumed by the job, rounded up to the nearest whole number.
     * </p>
     * 
     * @return The number of DPUs consumed by the job, rounded up to the nearest whole number.
     */
    public final Integer numberOfDpus() {
        return numberOfDpus;
    }

    /**
     * <p>
     * The duration of the job in hours.
     * </p>
     * 
     * @return The duration of the job in hours.
     */
    public final Double jobDurationInHour() {
        return jobDurationInHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBytesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFilesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(dpuHours());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(jobDurationInHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergCompactionMetrics)) {
            return false;
        }
        IcebergCompactionMetrics other = (IcebergCompactionMetrics) obj;
        return Objects.equals(numberOfBytesCompacted(), other.numberOfBytesCompacted())
                && Objects.equals(numberOfFilesCompacted(), other.numberOfFilesCompacted())
                && Objects.equals(dpuHours(), other.dpuHours()) && Objects.equals(numberOfDpus(), other.numberOfDpus())
                && Objects.equals(jobDurationInHour(), other.jobDurationInHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergCompactionMetrics").add("NumberOfBytesCompacted", numberOfBytesCompacted())
                .add("NumberOfFilesCompacted", numberOfFilesCompacted()).add("DpuHours", dpuHours())
                .add("NumberOfDpus", numberOfDpus()).add("JobDurationInHour", jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfBytesCompacted":
            return Optional.ofNullable(clazz.cast(numberOfBytesCompacted()));
        case "NumberOfFilesCompacted":
            return Optional.ofNullable(clazz.cast(numberOfFilesCompacted()));
        case "DpuHours":
            return Optional.ofNullable(clazz.cast(dpuHours()));
        case "NumberOfDpus":
            return Optional.ofNullable(clazz.cast(numberOfDpus()));
        case "JobDurationInHour":
            return Optional.ofNullable(clazz.cast(jobDurationInHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumberOfBytesCompacted", NUMBER_OF_BYTES_COMPACTED_FIELD);
        map.put("NumberOfFilesCompacted", NUMBER_OF_FILES_COMPACTED_FIELD);
        map.put("DpuHours", DPU_HOURS_FIELD);
        map.put("NumberOfDpus", NUMBER_OF_DPUS_FIELD);
        map.put("JobDurationInHour", JOB_DURATION_IN_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergCompactionMetrics, T> g) {
        return obj -> g.apply((IcebergCompactionMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergCompactionMetrics> {
        /**
         * <p>
         * The number of bytes removed by the compaction job run.
         * </p>
         * 
         * @param numberOfBytesCompacted
         *        The number of bytes removed by the compaction job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBytesCompacted(Long numberOfBytesCompacted);

        /**
         * <p>
         * The number of files removed by the compaction job run.
         * </p>
         * 
         * @param numberOfFilesCompacted
         *        The number of files removed by the compaction job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFilesCompacted(Long numberOfFilesCompacted);

        /**
         * <p>
         * The number of DPU hours consumed by the job.
         * </p>
         * 
         * @param dpuHours
         *        The number of DPU hours consumed by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpuHours(Double dpuHours);

        /**
         * <p>
         * The number of DPUs consumed by the job, rounded up to the nearest whole number.
         * </p>
         * 
         * @param numberOfDpus
         *        The number of DPUs consumed by the job, rounded up to the nearest whole number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDpus(Integer numberOfDpus);

        /**
         * <p>
         * The duration of the job in hours.
         * </p>
         * 
         * @param jobDurationInHour
         *        The duration of the job in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDurationInHour(Double jobDurationInHour);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfBytesCompacted;

        private Long numberOfFilesCompacted;

        private Double dpuHours;

        private Integer numberOfDpus;

        private Double jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergCompactionMetrics model) {
            numberOfBytesCompacted(model.numberOfBytesCompacted);
            numberOfFilesCompacted(model.numberOfFilesCompacted);
            dpuHours(model.dpuHours);
            numberOfDpus(model.numberOfDpus);
            jobDurationInHour(model.jobDurationInHour);
        }

        public final Long getNumberOfBytesCompacted() {
            return numberOfBytesCompacted;
        }

        public final void setNumberOfBytesCompacted(Long numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
        }

        @Override
        public final Builder numberOfBytesCompacted(Long numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
            return this;
        }

        public final Long getNumberOfFilesCompacted() {
            return numberOfFilesCompacted;
        }

        public final void setNumberOfFilesCompacted(Long numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
        }

        @Override
        public final Builder numberOfFilesCompacted(Long numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
            return this;
        }

        public final Double getDpuHours() {
            return dpuHours;
        }

        public final void setDpuHours(Double dpuHours) {
            this.dpuHours = dpuHours;
        }

        @Override
        public final Builder dpuHours(Double dpuHours) {
            this.dpuHours = dpuHours;
            return this;
        }

        public final Integer getNumberOfDpus() {
            return numberOfDpus;
        }

        public final void setNumberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final Double getJobDurationInHour() {
            return jobDurationInHour;
        }

        public final void setJobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        @Override
        public IcebergCompactionMetrics build() {
            return new IcebergCompactionMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
